/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.escape.CharEscaperBuilder;
import com.google.common.escape.Escaper;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OutputRenamingMapFormat {
    CLOSURE_COMPILED("goog.setCssNameMapping(%s);\n"),
    CLOSURE_COMPILED_BY_WHOLE("goog.setCssNameMapping(%s, 'BY_WHOLE');\n"),
    CLOSURE_COMPILED_SPLIT_HYPHENS("goog.setCssNameMapping(%s);\n"){

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, Writer renamingMapWriter) throws IOException {
            super.writeRenamingMap(OutputRenamingMapFormat.splitEntriesOnHyphens(renamingMap), renamingMapWriter);
        }
    }
    ,
    CLOSURE_UNCOMPILED("CLOSURE_CSS_NAME_MAPPING = %s;\n"),
    JSON,
    PROPERTIES{

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, Writer renamingMapWriter) throws IOException {
            OutputRenamingMapFormat.writeOnePerLine('=', renamingMap, renamingMapWriter);
        }

        @Override
        void readMapInto(BufferedReader in, ImmutableMap.Builder<? super String, ? super String> builder) throws IOException {
            OutputRenamingMapFormat.readOnePerLine('=', in, builder);
        }
    }
    ,
    JSCOMP_VARIABLE_MAP{

        @Override
        public void writeRenamingMap(Map<String, String> renamingMap, Writer renamingMapWriter) throws IOException {
            OutputRenamingMapFormat.writeOnePerLine(':', renamingMap, renamingMapWriter);
        }

        @Override
        void readMapInto(BufferedReader in, ImmutableMap.Builder<? super String, ? super String> builder) throws IOException {
            OutputRenamingMapFormat.readOnePerLine(':', in, builder);
        }
    };

    private final String formatString;
    private static final Escaper ESCAPER;
    private static final Splitter HYPHEN_SPLITTER;

    private OutputRenamingMapFormat(String formatString) {
        Preconditions.checkNotNull((Object)formatString);
        this.formatString = formatString;
    }

    private OutputRenamingMapFormat() {
        this("%s");
    }

    public void writeRenamingMap(Map<String, String> renamingMap, Writer renamingMapWriter) throws IOException {
        JsonObject properties = new JsonObject();
        for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
            properties.addProperty(entry.getKey(), entry.getValue());
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        renamingMapWriter.write(String.format(this.formatString, gson.toJson((JsonElement)properties)));
    }

    public final void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
        try {
            this.writeRenamingMap(renamingMap, (Writer)renamingMapWriter);
        }
        catch (IOException ex) {
            throw new AssertionError("IOException from PrintWriter", ex);
        }
    }

    public ImmutableMap<String, String> readRenamingMap(Reader in) throws IOException {
        String subsitutionMarker = "%s";
        int formatStringSubstitutionIndex = this.formatString.indexOf(subsitutionMarker);
        Preconditions.checkState((formatStringSubstitutionIndex >= 0 ? 1 : 0) != 0, (Object)this.formatString);
        String formatPrefix = this.formatString.substring(0, formatStringSubstitutionIndex);
        String formatSuffix = this.formatString.substring(formatStringSubstitutionIndex + subsitutionMarker.length());
        String content = CharStreams.toString((Readable)in);
        content = content.trim();
        formatPrefix = formatPrefix.trim();
        formatSuffix = formatSuffix.trim();
        if (!content.startsWith(formatPrefix) || !content.endsWith(formatSuffix) || content.length() < formatPrefix.length() + formatSuffix.length()) {
            throw new IOException("Input does not match format " + this.formatString + " : " + content);
        }
        content = content.substring(formatPrefix.length(), content.length() - formatSuffix.length());
        ImmutableMap.Builder b = ImmutableMap.builder();
        BufferedReader br = new BufferedReader(new StringReader(content));
        this.readMapInto(br, (ImmutableMap.Builder<? super String, ? super String>)b);
        OutputRenamingMapFormat.requireEndOfInput(br);
        return b.build();
    }

    void readMapInto(BufferedReader in, ImmutableMap.Builder<? super String, ? super String> builder) throws IOException {
        JsonElement json = JsonParser.parseReader((Reader)in);
        for (Map.Entry e : json.getAsJsonObject().entrySet()) {
            builder.put(e.getKey(), (Object)((JsonElement)e.getValue()).getAsString());
        }
    }

    private static void requireEndOfInput(BufferedReader in) throws IOException {
        int ch;
        while ((ch = in.read()) >= 0) {
            if (Character.isWhitespace((char)ch)) continue;
            throw new IOException("Expected end of input, not '" + OutputRenamingMapFormat.escape((char)ch) + "'");
        }
    }

    private static String escape(char ch) {
        return ESCAPER.escape(String.valueOf(ch));
    }

    private static Map<String, String> splitEntriesOnHyphens(Map<String, String> renamingMap) {
        LinkedHashMap newSplitRenamingMap = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
            Iterator keyParts = HYPHEN_SPLITTER.split((CharSequence)entry.getKey()).iterator();
            Iterator valueParts = HYPHEN_SPLITTER.split((CharSequence)entry.getValue()).iterator();
            while (keyParts.hasNext() && valueParts.hasNext()) {
                String valuePart;
                String keyPart = (String)keyParts.next();
                String oldValuePart = newSplitRenamingMap.put(keyPart, valuePart = (String)valueParts.next());
                Preconditions.checkState((oldValuePart == null || oldValuePart.equals(valuePart) ? 1 : 0) != 0);
            }
            if (keyParts.hasNext()) {
                throw new AssertionError((Object)("Not all parts of the original class name were output. Class: " + entry.getKey() + " Next Part:" + (String)keyParts.next()));
            }
            if (valueParts.hasNext()) {
                throw new AssertionError((Object)("Not all parts of the renamed class were output. Class: " + entry.getKey() + " Renamed Class: " + entry.getValue() + " Next Part:" + (String)valueParts.next()));
            }
        }
        return newSplitRenamingMap;
    }

    private static void writeOnePerLine(char separator, Map<String, String> renamingMap, Writer renamingMapWriter) throws IOException {
        for (Map.Entry<String, String> entry : renamingMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Preconditions.checkState((key.indexOf(separator) < 0 ? 1 : 0) != 0);
            Preconditions.checkState((key.indexOf(10) < 0 ? 1 : 0) != 0);
            Preconditions.checkState((value.indexOf(10) < 0 ? 1 : 0) != 0);
            renamingMapWriter.write(key);
            renamingMapWriter.write(separator);
            renamingMapWriter.write(value);
            renamingMapWriter.write(10);
        }
    }

    private static void readOnePerLine(char separator, BufferedReader in, ImmutableMap.Builder<? super String, ? super String> builder) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            int eq = line.indexOf(separator);
            if (eq < 0 && !line.isEmpty()) {
                throw new IOException("Line is missing a '" + separator + "': " + line);
            }
            builder.put((Object)line.substring(0, eq), (Object)line.substring(eq + 1));
        }
    }

    static {
        ESCAPER = new CharEscaperBuilder().addEscape('\t', "\\t").addEscape('\n', "\\n").addEscape('\r', "\\r").addEscape('\\', "\\\\").addEscape('\'', "\\'").toEscaper();
        HYPHEN_SPLITTER = Splitter.on((String)"-");
    }
}

