/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.css.Locatable;
import com.google.common.css.SourceCode;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public class SourceCodeLocation
implements Comparable<SourceCodeLocation>,
Serializable {
    private static final SourceCode UNKNOWN_SOURCE_CODE = new SourceCode("unknown", "");
    private static final Function<Locatable, SourceCodeLocation> LOCATABLE_TO_LOCATION = Locatable::getSourceCodeLocation;
    private final SourceCode sourceCode;
    private final SourceCodePoint begin;
    private final SourceCodePoint end;

    public static SourceCodeLocation getUnknownLocation() {
        SourceCodeLocation result = new SourceCodeLocation(UNKNOWN_SOURCE_CODE, -1, 0, 0, -1, 0, 0);
        Preconditions.checkState((boolean)result.isUnknown());
        Preconditions.checkState((boolean)result.begin.hasValidUnknownCoordinates());
        Preconditions.checkState((boolean)result.end.hasValidUnknownCoordinates());
        return result;
    }

    public static SourceCodeLocation merge(SourceCodeLocation beginLocation, SourceCodeLocation endLocation) {
        Preconditions.checkNotNull((Object)beginLocation, (Object)"Begin location can not be null");
        Preconditions.checkNotNull((Object)endLocation, (Object)"End location can not be null");
        Preconditions.checkArgument((boolean)beginLocation.sourceCode.equals(endLocation.sourceCode), (String)"Locations %s and %s come from different files; they cannot be merged", (Object)beginLocation, (Object)endLocation);
        Preconditions.checkArgument((beginLocation.compareTo(endLocation) <= 0 ? 1 : 0) != 0, (String)"Begin location %s must be less than or equal to end location %s", (Object)beginLocation, (Object)endLocation);
        return new SourceCodeLocation(beginLocation.sourceCode, beginLocation.getBeginCharacterIndex(), beginLocation.getBeginLineNumber(), beginLocation.getBeginIndexInLine(), endLocation.getEndCharacterIndex(), endLocation.getEndLineNumber(), endLocation.getEndIndexInLine());
    }

    public static SourceCodeLocation mergeAll(Iterable<SourceCodeLocation> locations) {
        Iterator<SourceCodeLocation> i = locations.iterator();
        SourceCodeLocation loc = null;
        while (i.hasNext() && loc == null) {
            loc = i.next();
        }
        if (!i.hasNext()) {
            return loc;
        }
        SourceCode sourceCode = loc.sourceCode;
        SourceCodePoint begin = loc.begin;
        SourceCodePoint end = loc.end;
        while (i.hasNext()) {
            loc = i.next();
            if (loc == null || loc.isUnknown() || !loc.sourceCode.equals(sourceCode)) continue;
            if (loc.begin.compareTo(begin) < 0) {
                begin = loc.begin;
            }
            if (loc.end.compareTo(end) <= 0) continue;
            end = loc.end;
        }
        return new SourceCodeLocation(sourceCode, begin, end);
    }

    public static SourceCodeLocation merge(Iterable<? extends Locatable> locations) {
        return SourceCodeLocation.mergeAll(StreamSupport.stream(locations.spliterator(), false).map(LOCATABLE_TO_LOCATION::apply).collect(Collectors.toList()));
    }

    @VisibleForTesting
    public SourceCodeLocation(SourceCode sourceCode, SourceCodePoint begin, SourceCodePoint end) {
        Preconditions.checkNotNull((Object)sourceCode);
        this.sourceCode = sourceCode;
        this.begin = begin;
        this.end = end;
        Preconditions.checkArgument((begin.compareTo(end) <= 0 ? 1 : 0) != 0, (Object)"Beginning location must come before the end location.");
    }

    public SourceCodeLocation(SourceCode sourceCode, int beginCharacterIndex, int beginLineNumber, int beginIndexInLine, int endCharacterIndex, int endLineNumber, int endIndexInLine) {
        this(sourceCode, new SourceCodePoint(beginCharacterIndex, beginLineNumber, beginIndexInLine), new SourceCodePoint(endCharacterIndex, endLineNumber, endIndexInLine));
    }

    public SourceCode getSourceCode() {
        return this.sourceCode;
    }

    public boolean isUnknown() {
        Preconditions.checkState((this.begin.isUnknown() == this.end.isUnknown() ? 1 : 0) != 0);
        return this.begin.isUnknown();
    }

    public int getBeginCharacterIndex() {
        return this.begin.getCharacterIndex();
    }

    public int getBeginLineNumber() {
        return this.begin.getLineNumber();
    }

    public int getBeginIndexInLine() {
        return this.begin.getIndexInLine();
    }

    public int getEndCharacterIndex() {
        return this.end.getCharacterIndex();
    }

    public int getEndLineNumber() {
        return this.end.getLineNumber();
    }

    public int getEndIndexInLine() {
        return this.end.getIndexInLine();
    }

    public int getCharacterIndex() {
        return this.getBeginCharacterIndex();
    }

    public int getLineNumber() {
        return this.getBeginLineNumber();
    }

    public int getIndexInLine() {
        return this.getBeginIndexInLine();
    }

    public SourceCodePoint getBegin() {
        return this.begin;
    }

    public SourceCodePoint getEnd() {
        return this.end;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SourceCodeLocation)) {
            return false;
        }
        SourceCodeLocation other = (SourceCodeLocation)o;
        return this.sourceCode == other.sourceCode && this.begin.equals(other.begin) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.sourceCode.hashCode() ^ this.begin.hashCode() ^ this.end.hashCode() << 16;
    }

    @Override
    public int compareTo(SourceCodeLocation o) {
        Preconditions.checkNotNull((Object)o);
        if (this.sourceCode != o.sourceCode) {
            if (this.sourceCode == null) {
                return -1;
            }
            if (o.sourceCode == null) {
                return 1;
            }
            return this.sourceCode.hashCode() - o.sourceCode.hashCode();
        }
        int startPointsComparison = this.begin.compareTo(o.begin);
        if (startPointsComparison != 0) {
            return startPointsComparison;
        }
        return this.end.compareTo(o.end);
    }

    public String toString() {
        return String.format("%s: [line %d, col %d -> line %d, col %d)", this.sourceCode.getFileName(), this.begin.getLineNumber(), this.begin.getIndexInLine(), this.end.getLineNumber(), this.end.getIndexInLine());
    }

    public static class SourceCodePoint
    implements Comparable<SourceCodePoint>,
    Serializable {
        private final int characterIndex;
        private final int lineNumber;
        private final int indexInLine;

        SourceCodePoint(int characterIndex, int lineNumber, int indexInLine) {
            this.lineNumber = lineNumber;
            this.indexInLine = indexInLine;
            this.characterIndex = characterIndex;
            if (!this.hasValidKnownCoordinates() && !this.hasValidUnknownCoordinates()) {
                throw new IllegalArgumentException(String.format("The location passed (lineNumber %d, indexInLine %d, characterIndex %d) is not valid.", lineNumber, indexInLine, characterIndex));
            }
            if (!this.hasPlausibleCoordinates()) {
                throw new IllegalArgumentException(String.format("The location passed (lineNumber %d, indexInLine %d, characterIndex %d) is not plausible.", lineNumber, indexInLine, characterIndex));
            }
        }

        SourceCodePoint(SourceCodePoint that) {
            this(that.characterIndex, that.lineNumber, that.indexInLine);
        }

        boolean hasValidKnownCoordinates() {
            return this.lineNumber >= 1 && this.indexInLine >= 1 && this.characterIndex >= 0;
        }

        boolean hasValidUnknownCoordinates() {
            return this.characterIndex == -1 && this.lineNumber == 0 && this.indexInLine == 0;
        }

        boolean hasPlausibleCoordinates() {
            return this.characterIndex >= this.lineNumber - 1 + this.indexInLine - 1;
        }

        int getCharacterIndex() {
            return this.characterIndex;
        }

        int getLineNumber() {
            return this.lineNumber;
        }

        int getIndexInLine() {
            return this.indexInLine;
        }

        boolean isUnknown() {
            return this.characterIndex == -1;
        }

        public boolean equals(@Nullable Object o) {
            boolean areEqual;
            if (o == null) {
                return false;
            }
            if (!(o instanceof SourceCodePoint)) {
                return false;
            }
            SourceCodePoint other = (SourceCodePoint)o;
            boolean bl = areEqual = this.characterIndex == other.characterIndex;
            if (areEqual) {
                Preconditions.checkState((this.lineNumber == other.lineNumber && this.indexInLine == other.indexInLine ? 1 : 0) != 0, (Object)"Character indexes are equal but line numbers and indexes within the line do not match.");
            } else {
                Preconditions.checkState((this.lineNumber != other.lineNumber || this.indexInLine != other.indexInLine ? 1 : 0) != 0, (Object)"Line numbers and indexes within the line match but character indexes are not equal");
            }
            return areEqual;
        }

        public int hashCode() {
            return this.characterIndex;
        }

        @Override
        public int compareTo(SourceCodePoint o) {
            Preconditions.checkNotNull((Object)o);
            return Ints.compare((int)this.characterIndex, (int)o.characterIndex);
        }
    }
}

