/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.css.SourceCode;
import com.google.common.css.SourceCodeLocation;

public class SourceCodeLocationBuilder {
    public static final String PASSED_LOCATION_IS_NOT_VALID = "The passed location is not valid.";
    private SourceCode sourceCode = null;
    private int beginCharacterIndex = -1;
    private int beginLineNumber = 0;
    private int beginIndexInLine = 0;
    private int endCharacterIndex = -1;
    private int endLineNumber = 0;
    private int endIndexInLine = 0;
    private SourceCodeLocation sourceCodeLocation = null;

    private void checkLocationIsNotAlreadyCreated() {
        Preconditions.checkState((this.sourceCodeLocation == null ? 1 : 0) != 0, (Object)"You cannot set source code location properties after the object was created.");
    }

    public SourceCodeLocationBuilder setSourceCode(SourceCode newSourceCode) {
        this.checkLocationIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)newSourceCode);
        this.sourceCode = newSourceCode;
        return this;
    }

    public boolean hasSourceCode() {
        return this.sourceCode != null;
    }

    public SourceCodeLocationBuilder setBeginLocation(int characterIndex, int lineNumber, int indexInLine) {
        this.checkLocationIsNotAlreadyCreated();
        Preconditions.checkArgument((characterIndex >= 0 ? 1 : 0) != 0, (Object)PASSED_LOCATION_IS_NOT_VALID);
        Preconditions.checkArgument((lineNumber >= 1 ? 1 : 0) != 0, (Object)PASSED_LOCATION_IS_NOT_VALID);
        Preconditions.checkArgument((indexInLine >= 1 ? 1 : 0) != 0, (Object)PASSED_LOCATION_IS_NOT_VALID);
        this.beginCharacterIndex = characterIndex;
        this.beginLineNumber = lineNumber;
        this.beginIndexInLine = indexInLine;
        return this;
    }

    public SourceCodeLocationBuilder setBeginLocation(SourceCodeLocation.SourceCodePoint begin) {
        this.checkLocationIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)begin);
        this.setBeginLocation(begin.getCharacterIndex(), begin.getLineNumber(), begin.getIndexInLine());
        return this;
    }

    public boolean hasBeginLocation() {
        return this.beginCharacterIndex != -1;
    }

    public SourceCodeLocationBuilder setEndLocation(int characterIndex, int lineNumber, int indexInLine) {
        this.checkLocationIsNotAlreadyCreated();
        Preconditions.checkArgument((characterIndex >= 0 ? 1 : 0) != 0, (Object)"The passed characterIndex is not valid.");
        Preconditions.checkArgument((lineNumber >= 1 ? 1 : 0) != 0, (Object)"The passed lineNumber is not valid.");
        Preconditions.checkArgument((indexInLine >= 1 ? 1 : 0) != 0, (Object)"The passed indexInLine is not valid.");
        this.endCharacterIndex = characterIndex;
        this.endLineNumber = lineNumber;
        this.endIndexInLine = indexInLine;
        return this;
    }

    public SourceCodeLocationBuilder setEndLocation(SourceCodeLocation.SourceCodePoint end) {
        this.checkLocationIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)end);
        this.setEndLocation(end.getCharacterIndex(), end.getLineNumber(), end.getIndexInLine());
        return this;
    }

    public SourceCodeLocationBuilder setLocation(int characterIndex, int lineNumber, int indexInLine) {
        this.checkLocationIsNotAlreadyCreated();
        this.setBeginLocation(characterIndex, lineNumber, indexInLine);
        this.setEndLocation(characterIndex, lineNumber, indexInLine);
        return this;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        if (this.sourceCodeLocation != null) {
            return this.sourceCodeLocation;
        }
        Preconditions.checkState((this.sourceCode != null ? 1 : 0) != 0, (Object)"You should specify a source code object");
        Preconditions.checkState((this.beginCharacterIndex >= 0 && this.endCharacterIndex >= 0 || this.beginCharacterIndex == -1 && this.endCharacterIndex == -1 ? 1 : 0) != 0, (Object)"Both the start and the end locations must be set.");
        Preconditions.checkState((this.hasSourceCode() || !this.hasBeginLocation() ? 1 : 0) != 0, (Object)"Must specify the source code if you specify a location.");
        try {
            this.sourceCodeLocation = new SourceCodeLocation(this.sourceCode, this.beginCharacterIndex, this.beginLineNumber, this.beginIndexInLine, this.endCharacterIndex, this.endLineNumber, this.endIndexInLine);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("with sourceCode = %s, beginCharacterIndex = %d, beginLineNumber = %d, beginIndexInLine = %d, endCharacterIndex = %d, endLineNumber = %d, endIndexInLine = %d", this.sourceCode.getFileContents(), this.beginCharacterIndex, this.beginLineNumber, this.beginIndexInLine, this.endCharacterIndex, this.endLineNumber, this.endIndexInLine), e);
        }
        return this.sourceCodeLocation;
    }
}

