/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.css.MultipleMappingSubstitutionMap;
import com.google.common.css.SubstitutionMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SplittingSubstitutionMap
implements MultipleMappingSubstitutionMap,
SubstitutionMap.Initializable {
    private static final Splitter DASH = Splitter.on((char)'-');
    private final SubstitutionMap delegate;

    public SplittingSubstitutionMap(SubstitutionMap substitutionMap) {
        this.delegate = substitutionMap;
    }

    @Override
    public void initializeWithMappings(Map<String, String> newMappings) {
        if (!newMappings.isEmpty()) {
            ((SubstitutionMap.Initializable)this.delegate).initializeWithMappings(newMappings);
        }
    }

    @Override
    public String get(String key) {
        return this.getValueWithMappings((String)key).value;
    }

    @Override
    public MultipleMappingSubstitutionMap.ValueWithMappings getValueWithMappings(String key) {
        Preconditions.checkNotNull((Object)key, (Object)"CSS key cannot be null");
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"CSS key cannot be empty");
        if (key.indexOf(45) == -1) {
            String value = this.delegate.get(key);
            return MultipleMappingSubstitutionMap.ValueWithMappings.createForSingleMapping(key, value);
        }
        StringBuilder buffer = new StringBuilder();
        LinkedHashMap mappings = Maps.newLinkedHashMap();
        for (String part : DASH.split((CharSequence)key)) {
            if (buffer.length() != 0) {
                buffer.append('-');
            }
            String value = this.delegate.get(part);
            mappings.put(part, value);
            buffer.append(value);
        }
        String renamedClassComposedFromParts = buffer.toString();
        return MultipleMappingSubstitutionMap.ValueWithMappings.createWithValueAndMappings(renamedClassComposedFromParts, (Map<String, String>)ImmutableMap.copyOf((Map)mappings));
    }
}

