/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.css.SourceCode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.GssParserCC;
import com.google.common.css.compiler.ast.GssParserException;
import com.google.common.css.compiler.ast.StringCharStream;
import java.util.List;

public abstract class AbstractGssParser {
    protected static final StringCharStream EMPTY_CHAR_STREAM = new StringCharStream("");

    protected final ParseResult parseInternal(List<SourceCode> sources, boolean errorHandling) throws GssParserException {
        SourceCode globalSourceCode = new SourceCode("global", null);
        CssBlockNode globalBlock = new CssBlockNode(false);
        CssTree tree = new CssTree(globalSourceCode, new CssRootNode(globalBlock));
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SourceCode source : sources) {
            this.getParser().parse(globalBlock, source, errorHandling, (ImmutableList.Builder<GssParserException>)builder);
        }
        return new ParseResult(tree, (ImmutableList<GssParserException>)builder.build());
    }

    protected abstract GssParserCC getParser();

    protected static class ParseResult {
        private final CssTree cssTree;
        private final ImmutableList<GssParserException> handledErrors;

        private ParseResult(CssTree cssTree, ImmutableList<GssParserException> handledErrors) {
            this.cssTree = cssTree;
            this.handledErrors = handledErrors;
        }

        protected CssTree getCssTree() {
            return this.cssTree;
        }

        protected ImmutableList<GssParserException> getHandledErrors() {
            return this.handledErrors;
        }
    }
}

