/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNodesListNode;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CssAbstractBlockNode
extends CssNodesListNode<CssNode> {
    private final ImmutableList<Class<? extends CssNode>> validNodeClasses;

    protected CssAbstractBlockNode(boolean isEnclosedWithBraces, List<Class<? extends CssNode>> validNodeClasses) {
        super(isEnclosedWithBraces, null);
        this.validNodeClasses = ImmutableList.copyOf(validNodeClasses);
    }

    protected CssAbstractBlockNode(boolean isEnclosedWithBraces, List<CssNode> childrenList, @Nullable List<CssCommentNode> comments, ImmutableList<Class<? extends CssNode>> validSuperclasses) {
        super(isEnclosedWithBraces, comments);
        this.validNodeClasses = validSuperclasses;
        this.setChildren(childrenList);
    }

    protected CssAbstractBlockNode(CssAbstractBlockNode node) {
        super(node.isEnclosedWithBraces(), node.getComments());
        this.setParent(node.getParent());
        this.setSourceCodeLocation(node.getSourceCodeLocation());
        this.validNodeClasses = node.validNodeClasses;
        for (CssNode child : node.childIterable()) {
            CssNode childCopy = child.deepCopy();
            this.addChildToBack(childCopy);
        }
    }

    @Override
    public abstract CssAbstractBlockNode deepCopy();

    @Override
    public void addChildToBack(CssNode child) {
        this.checkChild(child);
        super.addChildToBack(child);
    }

    @Override
    void setChildren(List<CssNode> children) {
        this.checkChildren(children);
        super.setChildren(children);
    }

    @Override
    public void replaceChildAt(int index, List<? extends CssNode> newChildren) {
        this.checkChildren(newChildren);
        super.replaceChildAt(index, newChildren);
    }

    private void checkChildren(List<? extends CssNode> children) {
        for (CssNode cssNode : children) {
            this.checkChild(cssNode);
        }
    }

    private void checkChild(CssNode node) {
        for (Class allowedClass : this.validNodeClasses) {
            if (!allowedClass.isInstance(node)) continue;
            return;
        }
        Preconditions.checkState((boolean)false, (String)"Trying to add an instance of the class %s (\"%s\"), which is not a valid child for a block of class %s.", (Object)node.getClass().getName(), (Object)node.toString(), (Object)this.getClass().getName());
    }
}

