/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Joiner;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CssCompositeValueNode
extends CssValueNode {
    private final List<CssValueNode> values;
    private final Operator operator;
    private final boolean hasParenthesis;

    CssCompositeValueNode(List<CssValueNode> compositeValues, Operator operator, boolean hasParenthesis, @Nullable SourceCodeLocation sourceCodeLocation) {
        super((String)null, sourceCodeLocation);
        this.operator = operator;
        this.values = new ArrayList<CssValueNode>(compositeValues);
        this.becomeParentForNodes(this.values);
        this.hasParenthesis = hasParenthesis;
    }

    public CssCompositeValueNode(List<CssValueNode> compositeValues, Operator operator, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(compositeValues, operator, false, sourceCodeLocation);
    }

    public CssCompositeValueNode(CssCompositeValueNode node) {
        this(CssCompositeValueNode.deepCopyCompositeValues(node.getValues()), node.getOperator(), node.hasParenthesis(), node.getSourceCodeLocation());
    }

    private static List<CssValueNode> deepCopyCompositeValues(List<CssValueNode> compositeValues) {
        ArrayList<CssValueNode> copy = new ArrayList<CssValueNode>(compositeValues.size());
        for (CssValueNode child : compositeValues) {
            copy.add(child.deepCopy());
        }
        return copy;
    }

    @Override
    public CssCompositeValueNode deepCopy() {
        return new CssCompositeValueNode(this);
    }

    public List<CssValueNode> getValues() {
        return this.values;
    }

    void addValue(CssValueNode value) {
        this.values.add(value);
        this.becomeParentForNode(value);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean hasParenthesis() {
        return this.hasParenthesis;
    }

    @Override
    public String toString() {
        String value = Joiner.on((String)this.operator.getOperatorName()).join(this.values);
        return this.hasParenthesis ? "(" + value + ")" : value;
    }

    public static enum Operator {
        SPACE(" "),
        COMMA(","),
        SLASH("/"),
        EQUALS("="),
        ADD(" + "),
        SUB(" - "),
        MULT("*"),
        DIV("/"),
        UNKNOWN(null);

        private final String operatorName;

        private Operator(String operatorName) {
            this.operatorName = operatorName;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public static Operator valueOf(char c) {
            switch (c) {
                case ',': {
                    return COMMA;
                }
                case '/': {
                    return SLASH;
                }
                case '=': {
                    return EQUALS;
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.getOperatorName();
        }
    }
}

