/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import java.util.List;
import javax.annotation.Nullable;

public class CssDeclarationNode
extends CssNode {
    private CssPropertyNode propertyName;
    private CssPropertyValueNode propertyValue;
    private boolean hasStarHack;

    public CssDeclarationNode(CssPropertyNode propertyName) {
        this(propertyName, new CssPropertyValueNode(), null);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(propertyName, new CssPropertyValueNode(), sourceCodeLocation);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, List<CssCommentNode> comments) {
        this(propertyName, comments, null);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, List<CssCommentNode> comments, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(propertyName, new CssPropertyValueNode(), comments, sourceCodeLocation);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(propertyName, propertyValue, null, sourceCodeLocation);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue, @Nullable List<CssCommentNode> comments, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(propertyName, propertyValue, comments, sourceCodeLocation, false);
    }

    public CssDeclarationNode(CssPropertyNode propertyName, CssPropertyValueNode propertyValue, @Nullable List<CssCommentNode> comments, @Nullable SourceCodeLocation sourceCodeLocation, boolean hasStarHack) {
        super(null, comments, sourceCodeLocation);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.becomeParentForNode(this.propertyName);
        this.becomeParentForNode(this.propertyValue);
        this.setStarHack(hasStarHack);
    }

    public CssDeclarationNode(CssDeclarationNode node) {
        this(node.getPropertyName().deepCopy(), node.getPropertyValue().deepCopy(), CssDeclarationNode.deepCopyNodes(node.getComments()), node.getSourceCodeLocation(), node.hasStarHack());
    }

    public CssDeclarationNode(CssPropertyNode propertyNode, CssPropertyValueNode cssPropertyValueNode) {
        this(propertyNode, cssPropertyValueNode, null);
    }

    @Override
    public CssDeclarationNode deepCopy() {
        return new CssDeclarationNode(this);
    }

    public CssPropertyNode getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(CssPropertyNode propertyName) {
        Preconditions.checkNotNull((Object)propertyName);
        this.removeAsParentOfNode(this.propertyName);
        this.propertyName = propertyName;
        this.becomeParentForNode(this.propertyName);
    }

    public CssPropertyValueNode getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyValue(CssPropertyValueNode propertyValue) {
        Preconditions.checkNotNull((Object)propertyValue);
        this.removeAsParentOfNode(this.propertyValue);
        this.propertyValue = propertyValue;
        this.becomeParentForNode(this.propertyValue);
    }

    public void setStarHack(boolean hasStarHack) {
        this.hasStarHack = hasStarHack;
    }

    public boolean hasStarHack() {
        return this.hasStarHack;
    }

    public boolean isCustomDeclaration() {
        return this.propertyName.isCustom();
    }

    @Override
    public String toString() {
        Object output = "";
        if (!this.getComments().isEmpty()) {
            output = this.getComments().toString();
        }
        if (this.hasStarHack()) {
            output = "*";
        }
        output = (String)output + this.getPropertyName().getValue() + ":" + this.getPropertyValue();
        return output;
    }
}

