/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssAbstractBlockNode;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.List;
import javax.annotation.Nullable;

public class CssForLoopRuleNode
extends CssAtRuleNode {
    public static final String VARIABLE_PREFIX = "$";
    private CssValueNode from;
    private CssValueNode to;
    private CssValueNode step;
    private final String variableName;
    private final int loopId;

    public CssForLoopRuleNode(CssLiteralNode name, CssAbstractBlockNode block, @Nullable List<CssCommentNode> comments, CssValueNode from, CssValueNode to, CssValueNode step, String variableName, int loopId, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(CssAtRuleNode.Type.FOR, name, block, comments);
        this.from = from;
        this.to = to;
        this.step = step;
        this.variableName = variableName;
        this.loopId = loopId;
        this.setSourceCodeLocation(sourceCodeLocation);
    }

    public CssForLoopRuleNode(CssForLoopRuleNode node) {
        super(node);
        this.from = node.from.deepCopy();
        this.to = node.to.deepCopy();
        this.step = node.step.deepCopy();
        this.variableName = node.variableName;
        this.loopId = node.loopId;
    }

    public CssValueNode getFrom() {
        return this.from;
    }

    public CssValueNode getTo() {
        return this.to;
    }

    public CssValueNode getStep() {
        return this.step;
    }

    public void setFrom(CssValueNode value) {
        this.from = value;
    }

    public void setTo(CssValueNode value) {
        this.to = value;
    }

    public void setStep(CssValueNode value) {
        this.step = value;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public int getLoopId() {
        return this.loopId;
    }

    @Override
    public CssBlockNode getBlock() {
        return (CssBlockNode)super.getBlock();
    }

    @Override
    public CssNode deepCopy() {
        return new CssForLoopRuleNode(this);
    }
}

