/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.ChunkAware;
import com.google.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.Map;
import javax.annotation.Nullable;

public class CssFunctionNode
extends CssValueNode
implements ChunkAware {
    private final Function function;
    private CssFunctionArgumentsNode arguments;
    private Object chunk;

    public CssFunctionNode(@Nullable Function function, @Nullable SourceCodeLocation sourceCodeLocation) {
        super((String)null, sourceCodeLocation);
        this.function = function;
        this.arguments = new CssFunctionArgumentsNode();
        this.becomeParentForNode(this.arguments);
    }

    public CssFunctionNode(CssFunctionNode function) {
        super(function);
        this.function = function.getFunction();
        this.arguments = new CssFunctionArgumentsNode(function.getArguments());
        this.becomeParentForNode(this.arguments);
        this.chunk = function.getChunk();
    }

    protected CssFunctionNode(@Nullable SourceCodeLocation sourceCodeLocation, @Nullable Function function) {
        super((String)null, sourceCodeLocation);
        this.function = function;
    }

    @Override
    public CssFunctionNode deepCopy() {
        return new CssFunctionNode(this);
    }

    public Function getFunction() {
        return this.function;
    }

    public String getFunctionName() {
        return this.function.toString();
    }

    public CssFunctionArgumentsNode getArguments() {
        return this.arguments;
    }

    public void setArguments(CssFunctionArgumentsNode arguments) {
        this.removeAsParentOfNode(this.arguments);
        this.arguments = arguments;
        this.becomeParentForNode(this.arguments);
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        if (this.function.getFunctionName() != null) {
            output.append(this.function.getFunctionName());
        }
        output.append("(");
        for (CssNode node : this.getArguments().childIterable()) {
            output.append(node.toString());
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public Object getChunk() {
        return this.chunk;
    }

    @Override
    public void setChunk(Object chunk) {
        this.chunk = chunk;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public static abstract class Function {
        private static final Map<String, Function> NAME_TO_FUNCTION_MAP;
        public static final Function CUSTOM;
        private final String functionName;

        private Function(String functionName) {
            this.functionName = functionName;
        }

        public static Function byName(String name) {
            return NAME_TO_FUNCTION_MAP.get(name);
        }

        public abstract boolean isRecognized();

        public String getFunctionName() {
            return this.functionName;
        }

        public String toString() {
            return this.getFunctionName();
        }

        static {
            ImmutableList recognizedCssFunctions = ImmutableList.of((Object)"attr", (Object)"counter", (Object)"rect", (Object)"rgb", (Object)"url", (Object)"domain", (Object)"url-prefix", (Object)"alpha", (Object)"cubic-bezier", (Object)"format", (Object)"from", (Object)"hsl", (Object[])new String[]{"hsla", "local", "matrix", "matrix3d", "perspective", "rgba", "rotate", "rotateX", "rotateY", "rotateZ", "rotate3d", "scale", "scaleX", "scaleY", "scaleZ", "scale3d", "skew", "skewX", "skewY", "steps", "to", "translate", "translateX", "translateY", "translateZ", "translate3d", "min", "max", "blur", "brightness", "contrast", "drop-shadow", "grayscale", "hue-rotate", "invert", "opacity", "saturate", "sepia", "image-set", "-moz-image-set", "-ms-image-set", "-o-image-set", "-webkit-image-set", "-khtml-gradient", "-webkit-gradient", "linear-gradient", "-moz-linear-gradient", "-ms-linear-gradient", "-o-linear-gradient", "-webkit-linear-gradient", "repeating-linear-gradient", "-moz-repeating-linear-gradient", "-ms-repeating-linear-gradient", "-o-repeating-linear-gradient", "-webkit-repeating-linear-gradient", "radial-gradient", "-moz-radial-gradient", "-ms-radial-gradient", "-o-radial-gradient", "-webkit-radial-gradient", "repeating-radial-gradient", "-moz-repeating-radial-gradient", "-ms-repeating-radial-gradient", "-o-repeating-radial-gradient", "-webkit-repeating-radial-gradient", "calc", "-webkit-calc", "-moz-calc", "inset", "circle", "ellipse", "polygon", "var"});
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String functionName : recognizedCssFunctions) {
                builder.put((Object)functionName, (Object)new Function(functionName){

                    @Override
                    public boolean isRecognized() {
                        return true;
                    }
                });
            }
            NAME_TO_FUNCTION_MAP = builder.build();
            CUSTOM = new Function(null){

                @Override
                public boolean isRecognized() {
                    return false;
                }
            };
        }
    }
}

