/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.ChunkAware;
import com.google.common.css.compiler.ast.CssNode;
import javax.annotation.Nullable;

public class CssKeyNode
extends CssNode
implements ChunkAware {
    private String keyValue;
    private Object chunk;

    public CssKeyNode(@Nullable String keyValue, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.keyValue = keyValue;
    }

    public CssKeyNode(String keyValue) {
        this(keyValue, null);
    }

    public CssKeyNode(CssKeyNode node) {
        this(node.getKeyValue(), node.getSourceCodeLocation());
        this.chunk = node.getChunk();
    }

    @Override
    public CssKeyNode deepCopy() {
        return new CssKeyNode(this);
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    @Override
    public void setChunk(Object chunk) {
        this.chunk = chunk;
    }

    @Override
    public Object getChunk() {
        return this.chunk;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.keyValue != null) {
            sb.append(this.keyValue);
        }
        return sb.toString();
    }
}

