/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssKeyListNode;
import com.google.common.css.compiler.ast.CssKeyNode;
import com.google.common.css.compiler.ast.CssNode;
import java.util.List;
import javax.annotation.Nullable;

public class CssKeyframeRulesetNode
extends CssNode {
    private CssKeyListNode keys;
    private final CssDeclarationBlockNode declarations;

    public CssKeyframeRulesetNode(CssDeclarationBlockNode declarations, @Nullable List<CssCommentNode> comments) {
        super(null, comments, null);
        Preconditions.checkNotNull((Object)declarations);
        this.declarations = declarations;
        this.becomeParentForNode(this.declarations);
        this.keys = new CssKeyListNode();
        this.becomeParentForNode(this.keys);
    }

    public CssKeyframeRulesetNode(CssDeclarationBlockNode declarations) {
        this(declarations, null);
    }

    public CssKeyframeRulesetNode() {
        this(new CssDeclarationBlockNode());
    }

    public CssKeyframeRulesetNode(List<CssCommentNode> comments) {
        this(new CssDeclarationBlockNode(), comments);
    }

    public CssKeyframeRulesetNode(CssKeyframeRulesetNode node) {
        this(node.getDeclarations().deepCopy());
        this.setComments(node.getComments());
        this.keys = node.getKeys().deepCopy();
    }

    @Override
    public CssKeyframeRulesetNode deepCopy() {
        return new CssKeyframeRulesetNode(this);
    }

    public CssKeyListNode getKeys() {
        return this.keys;
    }

    void setKeys(CssKeyListNode keys) {
        Preconditions.checkNotNull((Object)keys);
        this.removeAsParentOfNode(this.keys);
        this.keys = keys;
        this.becomeParentForNode(this.keys);
    }

    public CssDeclarationBlockNode getDeclarations() {
        return this.declarations;
    }

    public void addDeclaration(CssDeclarationNode declaration) {
        this.declarations.addChildToBack(declaration);
    }

    public void addKey(CssKeyNode key) {
        this.keys.addChildToBack(key);
    }

    @Override
    public String toString() {
        Object output = "";
        if (!this.getComments().isEmpty()) {
            output = this.getComments().toString();
        }
        output = (String)output + this.keys.toString() + "{" + this.declarations.toString() + "}";
        return output;
    }
}

