/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.css.Locatable;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.DefaultVisitController;
import com.google.common.css.compiler.ast.VisitController;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public abstract class CssNode
implements Locatable {
    private CssNode parent;
    private SourceCodeLocation sourceCodeLocation;
    private List<CssCommentNode> comments;
    private boolean shouldBeFlipped = true;

    protected CssNode() {
        this(null, null);
    }

    protected CssNode(@Nullable SourceCodeLocation sourceCodeLocation) {
        this(null, sourceCodeLocation);
    }

    protected CssNode(@Nullable CssNode parent) {
        this(parent, null);
    }

    protected CssNode(@Nullable CssNode parent, @Nullable SourceCodeLocation sourceCodeLocation) {
        this(parent, null, sourceCodeLocation);
    }

    protected CssNode(@Nullable CssNode parent, @Nullable List<CssCommentNode> comments, @Nullable SourceCodeLocation sourceCodeLocation) {
        this.parent = parent;
        this.sourceCodeLocation = sourceCodeLocation;
        this.comments = comments == null ? Lists.newArrayListWithExpectedSize((int)0) : Lists.newArrayList(comments);
        this.becomeParentForNodes(this.comments);
    }

    public abstract CssNode deepCopy();

    public CssNode getParent() {
        return this.parent;
    }

    void setParent(CssNode parent) {
        this.parent = parent;
    }

    @Override
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public void setSourceCodeLocation(@Nullable SourceCodeLocation sourceCodeLocation) {
        this.sourceCodeLocation = sourceCodeLocation;
    }

    void removeParent() {
        this.parent = null;
    }

    void removeAsParentOfNode(CssNode child) {
        if (child == null) {
            return;
        }
        Preconditions.checkArgument((child.getParent() == this ? 1 : 0) != 0);
        child.removeParent();
    }

    void removeAsParentOfNodes(List<? extends CssNode> children) {
        if (children == null) {
            return;
        }
        for (CssNode cssNode : children) {
            this.removeAsParentOfNode(cssNode);
        }
    }

    final void becomeParentForNode(@Nullable CssNode child) {
        if (child == null) {
            return;
        }
        child.setParent(this);
    }

    final void becomeParentForNodes(List<? extends CssNode> children) {
        Preconditions.checkNotNull(children);
        if (children.isEmpty()) {
            return;
        }
        for (CssNode cssNode : children) {
            this.becomeParentForNode(cssNode);
        }
    }

    public void appendComment(CssCommentNode comment) {
        this.comments.add(comment);
        this.becomeParentForNode(comment);
    }

    public void setComments(List<CssCommentNode> comments) {
        Preconditions.checkNotNull(this.comments);
        this.removeAsParentOfNodes(this.comments);
        this.comments = Lists.newArrayList(comments);
        this.becomeParentForNodes(this.comments);
    }

    public List<CssCommentNode> getComments() {
        return this.comments;
    }

    public boolean hasComment(String comment) {
        for (CssCommentNode c : this.comments) {
            if (!c.getValue().equals(comment)) continue;
            return true;
        }
        return false;
    }

    public boolean getShouldBeFlipped() {
        return this.shouldBeFlipped;
    }

    public void setShouldBeFlipped(boolean shouldBeFlipped) {
        this.shouldBeFlipped = shouldBeFlipped;
    }

    <T extends CssNode> List<T> copyToList(List<T> list) {
        return Lists.newArrayList(list);
    }

    public final boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return super.toString();
    }

    public Iterable<CssNode> ancestors() {
        return () -> new UnmodifiableIterator<CssNode>(){
            private CssNode current;
            {
                this.current = CssNode.this;
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public CssNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                CssNode result = this.current;
                this.current = this.current.getParent();
                return result;
            }
        };
    }

    public boolean inFunArgs() {
        for (CssNode n : this.ancestors()) {
            if (!(n instanceof CssFunctionNode)) continue;
            return true;
        }
        return false;
    }

    public VisitController getVisitController() {
        return new DefaultVisitController(this, false);
    }

    public static <N extends CssNode> List<N> deepCopyNodes(List<N> nodes) {
        ArrayList list = Lists.newArrayList();
        for (CssNode node : nodes) {
            CssNode copy = node.deepCopy();
            list.add(copy);
        }
        return list;
    }
}

