/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssSelectorNode;

public class CssPseudoClassNode
extends CssRefinerNode {
    private static final ImmutableSet<String> COMPATIBILITY_PSEUDO_ELEMENTS = ImmutableSet.of((Object)"first-line", (Object)"first-letter", (Object)"before", (Object)"after");
    private final FunctionType functionType;
    private String argument;
    private final CssSelectorNode notSelector;

    public CssPseudoClassNode(String name, SourceCodeLocation sourceCodeLocation) {
        this(FunctionType.NONE, name, null, null, sourceCodeLocation);
    }

    public CssPseudoClassNode(FunctionType functionType, String name, String argument, SourceCodeLocation sourceCodeLocation) {
        this(functionType, name, argument, null, sourceCodeLocation);
        Preconditions.checkArgument((functionType != FunctionType.NOT && functionType != FunctionType.NONE ? 1 : 0) != 0);
    }

    public CssPseudoClassNode(String name, CssSelectorNode notSelector, SourceCodeLocation sourceCodeLocation) {
        this(FunctionType.NOT, name, null, notSelector, sourceCodeLocation);
    }

    public CssPseudoClassNode(CssPseudoClassNode node) {
        this(node.functionType, node.refinerName, node.argument, node.notSelector, node.getSourceCodeLocation());
    }

    private CssPseudoClassNode(FunctionType functionType, String name, String argument, CssSelectorNode notSelector, SourceCodeLocation sourceCodeLocation) {
        super(CssRefinerNode.Refiner.PSEUDO_CLASS, name, sourceCodeLocation);
        this.functionType = functionType;
        this.argument = argument;
        this.notSelector = notSelector;
    }

    @Override
    public CssPseudoClassNode deepCopy() {
        return new CssPseudoClassNode(this);
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public String getArgument() {
        return this.argument;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public CssSelectorNode getNotSelector() {
        return this.notSelector;
    }

    @Override
    public CssSelectorNode.Specificity getSpecificity() {
        if (COMPATIBILITY_PSEUDO_ELEMENTS.contains((Object)this.refinerName)) {
            return new CssSelectorNode.Specificity(0, 0, 1);
        }
        if (this.functionType == FunctionType.NOT) {
            return this.notSelector.getSpecificity();
        }
        return new CssSelectorNode.Specificity(0, 1, 0);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.refinerType.getPrefix());
        sb.append(this.refinerName);
        switch (this.functionType) {
            case NONE: {
                sb.append(this.refinerType.getSuffix());
                break;
            }
            case LANG: 
            case NTH: {
                sb.append(this.argument);
                break;
            }
            case NOT: {
                sb.append(this.notSelector.toString());
            }
        }
        if (this.functionType != FunctionType.NONE) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static enum FunctionType {
        NONE,
        LANG,
        NTH,
        NOT;

    }
}

