/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.css.Vendor;
import java.util.Set;
import javax.annotation.Nullable;

public final class Property {
    private static final String CUSTOM_PROPERTY_PREFIX = "--";
    private static final String BORDER = "border";
    private static final String BORDER_RADIUS = "border-radius";
    private static final String MOZ_BORDER_RADIUS = "-moz-border-radius";
    private static final String WEBKIT_BORDER_RADIUS = "-webkit-border-radius";
    private static final String FLEX_BOX_NO_SUPPORT = "The flexbox spec has changed and this property is no longer supported.";
    private static final BiMap<String, Property> NAME_TO_PROPERTY_MAP;
    private final String name;
    private final Set<String> shorthands;
    private final String partition;
    @Nullable
    private final Vendor vendor;
    private final boolean hasPositionalParameters;
    private final boolean isCustom;
    private final boolean isSvgOnly;
    private final String warning;

    private Property(String name, Set<String> shorthands, String partition, @Nullable Vendor vendor, boolean hasPositionDependentValues, boolean isCustom, boolean isSvgOnly, @Nullable String warning) {
        if (!isCustom) {
            Preconditions.checkArgument((boolean)name.equals(name.toLowerCase()), (String)"property name should be all lowercase: %s", (Object)name);
        }
        this.name = name;
        this.shorthands = shorthands;
        this.partition = partition;
        this.vendor = vendor;
        this.hasPositionalParameters = hasPositionDependentValues;
        this.isCustom = isCustom;
        this.isSvgOnly = isSvgOnly;
        this.warning = warning;
    }

    private static Property createUserDefinedProperty(String name) {
        Preconditions.checkArgument((!NAME_TO_PROPERTY_MAP.containsKey((Object)name) ? 1 : 0) != 0);
        Builder builder = Property.builder(name).setShorthands((Set<String>)ImmutableSet.of());
        if (name.startsWith(CUSTOM_PROPERTY_PREFIX)) {
            builder.isCustom();
        }
        return builder.build();
    }

    public static Property byName(String name) {
        Property property;
        if (!name.startsWith(CUSTOM_PROPERTY_PREFIX)) {
            name = name.toLowerCase();
        }
        if ((property = (Property)NAME_TO_PROPERTY_MAP.get((Object)name)) != null) {
            return property;
        }
        return Property.createUserDefinedProperty(name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRecognizedProperty() {
        return NAME_TO_PROPERTY_MAP.containsKey((Object)this.name);
    }

    public Set<String> getShorthands() {
        return this.shorthands;
    }

    public String getPartition() {
        return this.partition;
    }

    public boolean isVendorSpecific() {
        return this.vendor != null;
    }

    @Nullable
    public Vendor getVendor() {
        return this.vendor;
    }

    public boolean hasPositionalParameters() {
        return this.hasPositionalParameters;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public boolean isSvgOnly() {
        return this.isSvgOnly;
    }

    public boolean hasWarning() {
        return this.warning != null;
    }

    public String getWarning() {
        return this.warning;
    }

    public static Set<String> allRecognizedPropertyNames() {
        return NAME_TO_PROPERTY_MAP.keySet();
    }

    public static Set<Property> allRecognizedProperties() {
        return NAME_TO_PROPERTY_MAP.values();
    }

    private static Builder builder(String name) {
        return new Builder(name);
    }

    static {
        ImmutableList recognizedProperties = ImmutableList.of((Object)Property.builder("align-content"), (Object)Property.builder("align-items"), (Object)Property.builder("align-self"), (Object)Property.builder("alignment-baseline").isSvgOnly(), (Object)Property.builder("all"), (Object)Property.builder("animation"), (Object)Property.builder("animation-delay"), (Object)Property.builder("animation-direction"), (Object)Property.builder("animation-duration"), (Object)Property.builder("animation-fill-mode"), (Object)Property.builder("animation-iteration-count"), (Object)Property.builder("animation-name"), (Object[])new Builder[]{Property.builder("animation-play-state"), Property.builder("animation-timing-function"), Property.builder("azimuth"), Property.builder("backface-visibility"), Property.builder("background-attachment"), Property.builder("background-clip"), Property.builder("background-color"), Property.builder("background-image"), Property.builder("background-origin"), Property.builder("background-position"), Property.builder("background-position-x"), Property.builder("background-position-y"), Property.builder("background-repeat"), Property.builder("background-size"), Property.builder("background"), Property.builder("baseline-shift").isSvgOnly(), Property.builder("border-collapse"), Property.builder("border-color").setHasPositionalParameters(true), Property.builder("border-spacing"), Property.builder("border-style").setHasPositionalParameters(true), Property.builder("border-top"), Property.builder("border-right"), Property.builder("border-bottom"), Property.builder("border-left"), Property.builder("border-top-color"), Property.builder("border-right-color"), Property.builder("border-bottom-color"), Property.builder("border-left-color"), Property.builder("border-top-style"), Property.builder("border-right-style"), Property.builder("border-bottom-style"), Property.builder("border-left-style"), Property.builder("border-top-width"), Property.builder("border-right-width"), Property.builder("border-bottom-width"), Property.builder("border-left-width"), Property.builder("border-width").setHasPositionalParameters(true), Property.builder("border-image"), Property.builder(BORDER_RADIUS), Property.builder("border-top-left-radius"), Property.builder("border-top-right-radius"), Property.builder("border-bottom-right-radius"), Property.builder("border-bottom-left-radius"), Property.builder(BORDER), Property.builder("bottom"), Property.builder("box-align").warn(FLEX_BOX_NO_SUPPORT), Property.builder("box-flex").warn(FLEX_BOX_NO_SUPPORT), Property.builder("box-orient").warn(FLEX_BOX_NO_SUPPORT), Property.builder("box-pack").warn(FLEX_BOX_NO_SUPPORT), Property.builder("box-shadow"), Property.builder("box-sizing"), Property.builder("break-after"), Property.builder("break-before"), Property.builder("break-inside"), Property.builder("caption-side"), Property.builder("caret-color"), Property.builder("clear"), Property.builder("clip"), Property.builder("clip-path").isSvgOnly(), Property.builder("clip-rule").isSvgOnly(), Property.builder("color"), Property.builder("color-adjust"), Property.builder("color-interpolation").isSvgOnly(), Property.builder("color-interpolation-filters").isSvgOnly(), Property.builder("color-profile").isSvgOnly(), Property.builder("color-rendering").isSvgOnly(), Property.builder("column-break-inside"), Property.builder("column-count"), Property.builder("column-fill"), Property.builder("column-gap"), Property.builder("column-rule"), Property.builder("column-rule-color"), Property.builder("column-rule-style"), Property.builder("column-rule-width"), Property.builder("column-span"), Property.builder("column-width"), Property.builder("columns"), Property.builder("contain"), Property.builder("content"), Property.builder("counter-increment"), Property.builder("counter-reset"), Property.builder("cue-after"), Property.builder("cue-before"), Property.builder("cue"), Property.builder("cursor"), Property.builder("direction"), Property.builder("display"), Property.builder("dominant-baseline").isSvgOnly(), Property.builder("elevation"), Property.builder("empty-cells"), Property.builder("enable-background").isSvgOnly(), Property.builder("-epub-caption-side"), Property.builder("-epub-hyphens"), Property.builder("-epub-text-combine"), Property.builder("-epub-text-emphasis"), Property.builder("-epub-text-emphasis-color"), Property.builder("-epub-text-emphasis-style"), Property.builder("-epub-text-orientation"), Property.builder("-epub-text-transform"), Property.builder("-epub-word-break"), Property.builder("-epub-writing-mode"), Property.builder("fill").isSvgOnly(), Property.builder("fill-opacity").isSvgOnly(), Property.builder("fill-rule").isSvgOnly(), Property.builder("filter"), Property.builder("flex"), Property.builder("flex-basis"), Property.builder("flex-direction"), Property.builder("flex-flow"), Property.builder("flex-grow"), Property.builder("flex-shrink"), Property.builder("flex-wrap"), Property.builder("float"), Property.builder("flood-color").isSvgOnly(), Property.builder("flood-opacity").isSvgOnly(), Property.builder("font"), Property.builder("font-family"), Property.builder("font-feature-settings"), Property.builder("font-kerning"), Property.builder("font-language-override"), Property.builder("font-size"), Property.builder("font-size-adjust"), Property.builder("font-stretch"), Property.builder("font-style"), Property.builder("font-synthesis"), Property.builder("font-variant"), Property.builder("font-variant-alternates"), Property.builder("font-variant-caps"), Property.builder("font-variant-east-asian"), Property.builder("font-variant-ligatures"), Property.builder("font-variant-numeric"), Property.builder("font-variant-position"), Property.builder("font-weight"), Property.builder("glyph-orientation-horizontal").isSvgOnly(), Property.builder("glyph-orientation-vertical").isSvgOnly(), Property.builder("grid"), Property.builder("grid-area"), Property.builder("grid-auto-columns"), Property.builder("grid-auto-flow"), Property.builder("grid-auto-rows"), Property.builder("grid-column"), Property.builder("grid-column-end"), Property.builder("grid-column-gap"), Property.builder("grid-column-start"), Property.builder("grid-gap"), Property.builder("grid-row"), Property.builder("grid-row-end"), Property.builder("grid-row-gap"), Property.builder("grid-row-start"), Property.builder("grid-template"), Property.builder("grid-template-areas"), Property.builder("grid-template-columns"), Property.builder("grid-template-rows"), Property.builder("height"), Property.builder("image-rendering").isSvgOnly(), Property.builder("justify-content"), Property.builder("justify-items"), Property.builder("justify-self"), Property.builder("kerning").isSvgOnly(), Property.builder("-khtml-user-select"), Property.builder("left"), Property.builder("letter-spacing"), Property.builder("lighting-color").isSvgOnly(), Property.builder("line-height"), Property.builder("list-style-image"), Property.builder("list-style-position"), Property.builder("list-style-type"), Property.builder("list-style"), Property.builder("margin-right"), Property.builder("margin-left"), Property.builder("margin-top"), Property.builder("margin-bottom"), Property.builder("margin").setHasPositionalParameters(true), Property.builder("marker").isSvgOnly(), Property.builder("marker-end").isSvgOnly(), Property.builder("marker-mid").isSvgOnly(), Property.builder("marker-start").isSvgOnly(), Property.builder("mask").isSvgOnly(), Property.builder("max-height"), Property.builder("max-width"), Property.builder("min-height"), Property.builder("min-width"), Property.builder("mix-blend-mode"), Property.builder("-moz-animation"), Property.builder("-moz-animation-delay"), Property.builder("-moz-animation-direction"), Property.builder("-moz-animation-duration"), Property.builder("-moz-animation-fill-mode"), Property.builder("-moz-animation-iteration-count"), Property.builder("-moz-animation-name"), Property.builder("-moz-animation-play-state"), Property.builder("-moz-animation-timing-function"), Property.builder("-moz-appearance"), Property.builder("-moz-backface-visibility"), Property.builder("-moz-background-clip"), Property.builder("-moz-background-inline-policy"), Property.builder("-moz-background-origin"), Property.builder("-moz-background-size"), Property.builder("-moz-binding"), Property.builder("-moz-border-bottom-colors"), Property.builder("-moz-border-end"), Property.builder("-moz-border-end-color"), Property.builder("-moz-border-end-style"), Property.builder("-moz-border-end-width"), Property.builder("-moz-border-image"), Property.builder("-moz-border-left-colors"), Property.builder(MOZ_BORDER_RADIUS), Property.builder("-moz-border-radius-topleft"), Property.builder("-moz-border-radius-topright"), Property.builder("-moz-border-radius-bottomright"), Property.builder("-moz-border-radius-bottomleft"), Property.builder("-moz-border-right-colors"), Property.builder("-moz-border-start"), Property.builder("-moz-border-start-color"), Property.builder("-moz-border-start-style"), Property.builder("-moz-border-start-width"), Property.builder("-moz-border-top-colors"), Property.builder("-moz-box-align"), Property.builder("-moz-box-align-content"), Property.builder("-moz-box-direction"), Property.builder("-moz-box-flex"), Property.builder("-moz-box-ordinal-group"), Property.builder("-moz-box-orient"), Property.builder("-moz-box-pack"), Property.builder("-moz-box-shadow"), Property.builder("-moz-box-sizing"), Property.builder("moz-column-break-inside"), Property.builder("-moz-column-count"), Property.builder("-moz-column-gap"), Property.builder("-moz-column-rule"), Property.builder("-moz-column-rule-color"), Property.builder("-moz-column-rule-style"), Property.builder("-moz-column-rule-width"), Property.builder("-moz-column-width"), Property.builder("-moz-columns"), Property.builder("-moz-filter"), Property.builder("-moz-flex"), Property.builder("-moz-flex-direction"), Property.builder("-moz-flex-grow"), Property.builder("-moz-flex-flow"), Property.builder("-moz-flex-shrink"), Property.builder("-moz-flex-wrap"), Property.builder("-moz-float-edge"), Property.builder("-moz-font-feature-settings"), Property.builder("-moz-font-language-override"), Property.builder("-moz-force-broken-image-icon"), Property.builder("-moz-hyphens"), Property.builder("-moz-image-region"), Property.builder("-moz-justify-content"), Property.builder("-moz-margin-end"), Property.builder("-moz-margin-start"), Property.builder("-moz-opacity"), Property.builder("-moz-orient"), Property.builder("-moz-osx-font-smoothing"), Property.builder("-moz-outline-radius"), Property.builder("-moz-outline-radius-bottomleft"), Property.builder("-moz-outline-radius-bottomright"), Property.builder("-moz-outline-radius-topleft"), Property.builder("-moz-outline-radius-topright"), Property.builder("-moz-padding-end"), Property.builder("-moz-padding-start"), Property.builder("-moz-perspective"), Property.builder("-moz-perspective-origin"), Property.builder("-moz-script-level"), Property.builder("-moz-script-min-size"), Property.builder("-moz-script-size-multiplier"), Property.builder("-moz-stack-sizing"), Property.builder("-moz-tab-size"), Property.builder("-moz-text-blink"), Property.builder("-moz-text-decoration-color"), Property.builder("-moz-text-decoration-line"), Property.builder("-moz-text-decoration-style"), Property.builder("-moz-text-size-adjust"), Property.builder("-moz-text-shadow"), Property.builder("-moz-transform"), Property.builder("-moz-transform-origin"), Property.builder("-moz-transform-style"), Property.builder("-moz-transition"), Property.builder("-moz-transition-delay"), Property.builder("-moz-transition-duration"), Property.builder("-moz-transition-property"), Property.builder("-moz-transition-timing-function"), Property.builder("-moz-user-focus"), Property.builder("-moz-user-input"), Property.builder("-moz-user-modify"), Property.builder("-moz-user-select"), Property.builder("-moz-window-shadow"), Property.builder("-ms-accelerator"), Property.builder("-ms-align-items"), Property.builder("-ms-animation"), Property.builder("-ms-animation-delay"), Property.builder("-ms-animation-direction"), Property.builder("-ms-animation-duration"), Property.builder("-ms-animation-fill-mode"), Property.builder("-ms-animation-iteration-count"), Property.builder("-ms-animation-name"), Property.builder("-ms-animation-play-state"), Property.builder("-ms-animation-timing-function"), Property.builder("-ms-appearance"), Property.builder("-ms-background-position-x"), Property.builder("-ms-background-position-y"), Property.builder("-ms-behavior"), Property.builder("-ms-block-progression"), Property.builder("-ms-box-align"), Property.builder("-ms-border-radius"), Property.builder("-ms-box-direction"), Property.builder("-ms-box-flex"), Property.builder("-ms-box-line-progression"), Property.builder("-ms-box-lines"), Property.builder("-ms-box-ordinal-group"), Property.builder("-ms-box-orient"), Property.builder("-ms-box-pack"), Property.builder("-ms-box-shadow"), Property.builder("-ms-box-sizing"), Property.builder("-ms-filter"), Property.builder("-ms-flex"), Property.builder("-ms-flex-align"), Property.builder("-ms-flex-direction"), Property.builder("-ms-flex-flow"), Property.builder("-ms-flex-grow"), Property.builder("-ms-flex-negative"), Property.builder("-ms-flex-order"), Property.builder("-ms-flex-pack"), Property.builder("-ms-flex-positive"), Property.builder("-ms-flex-preferred-size"), Property.builder("-ms-flex-shrink"), Property.builder("-ms-flex-wrap"), Property.builder("-ms-grid-column"), Property.builder("-ms-grid-column-align"), Property.builder("-ms-grid-column-span"), Property.builder("-ms-grid-columns"), Property.builder("-ms-grid-layer"), Property.builder("-ms-grid-row"), Property.builder("-ms-grid-row-align"), Property.builder("-ms-grid-row-span"), Property.builder("-ms-grid-rows"), Property.builder("-ms-high-contrast-adjust"), Property.builder("-ms-ime-mode"), Property.builder("-ms-interpolation-mode"), Property.builder("-ms-justify-content"), Property.builder("-ms-layout-flow"), Property.builder("-ms-layout-grid"), Property.builder("-ms-layout-grid-char"), Property.builder("-ms-layout-grid-line"), Property.builder("-ms-layout-grid-mode"), Property.builder("-ms-layout-grid-type"), Property.builder("-ms-line-break"), Property.builder("-ms-line-grid-mode"), Property.builder("-ms-overflow-style"), Property.builder("-ms-overflow-x"), Property.builder("-ms-overflow-y"), Property.builder("-ms-scrollbar-3dlight-color"), Property.builder("-ms-scrollbar-arrow-color"), Property.builder("-ms-scrollbar-base-color"), Property.builder("-ms-scrollbar-darkshadow-color"), Property.builder("-ms-scrollbar-face-color"), Property.builder("-ms-scrollbar-highlight-color"), Property.builder("-ms-scrollbar-shadow-color"), Property.builder("-ms-scrollbar-track-color"), Property.builder("-ms-text-align-last"), Property.builder("-ms-text-autospace"), Property.builder("-ms-text-justify"), Property.builder("-ms-text-kashida-space"), Property.builder("-ms-text-overflow"), Property.builder("-ms-text-size-adjust"), Property.builder("-ms-text-underline-position"), Property.builder("-ms-touch-action"), Property.builder("-ms-transform"), Property.builder("-ms-transform-origin"), Property.builder("-ms-transition"), Property.builder("-ms-transition-delay"), Property.builder("-ms-transition-duration"), Property.builder("-ms-transition-property"), Property.builder("-ms-transition-timing-function"), Property.builder("-ms-user-select"), Property.builder("-ms-word-break"), Property.builder("-ms-word-wrap"), Property.builder("-ms-writing-mode"), Property.builder("-ms-zoom"), Property.builder("-o-animation"), Property.builder("-o-animation-delay"), Property.builder("-o-animation-direction"), Property.builder("-o-animation-duration"), Property.builder("-o-animation-fill-mode"), Property.builder("-o-animation-iteration-count"), Property.builder("-o-animation-name"), Property.builder("-o-animation-play-state"), Property.builder("-o-animation-timing-function"), Property.builder("-o-background-size"), Property.builder("-o-border-radius"), Property.builder("-o-box-shadow"), Property.builder("-o-filter"), Property.builder("-o-object-fit"), Property.builder("-o-object-position"), Property.builder("-o-text-overflow"), Property.builder("-o-text-shadow"), Property.builder("-o-transform"), Property.builder("-o-transform-origin"), Property.builder("-o-transition"), Property.builder("-o-transition-delay"), Property.builder("-o-transition-duration"), Property.builder("-o-transition-property"), Property.builder("-o-transition-timing-function"), Property.builder("-o-user-select"), Property.builder("object-fit"), Property.builder("object-position"), Property.builder("opacity"), Property.builder("order"), Property.builder("orphans"), Property.builder("outline-color"), Property.builder("outline-offset"), Property.builder("outline-style"), Property.builder("outline-width"), Property.builder("outline"), Property.builder("overflow"), Property.builder("overflow-x"), Property.builder("overflow-y"), Property.builder("overflow-wrap"), Property.builder("padding-top"), Property.builder("padding-right"), Property.builder("padding-bottom"), Property.builder("padding-left"), Property.builder("padding").setHasPositionalParameters(true), Property.builder("page-break-after"), Property.builder("page-break-before"), Property.builder("page-break-inside"), Property.builder("pause-after"), Property.builder("pause-before"), Property.builder("pause"), Property.builder("perspective"), Property.builder("perspective-origin"), Property.builder("pitch-range"), Property.builder("pitch"), Property.builder("play-during"), Property.builder("pointer-events"), Property.builder("position"), Property.builder("quotes"), Property.builder("resize"), Property.builder("richness"), Property.builder("right"), Property.builder("scrollbar-3dlight-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-arrow-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-base-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-darkshadow-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-face-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-highlight-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-shadow-color").setVendor(Vendor.MICROSOFT), Property.builder("scrollbar-track-color").setVendor(Vendor.MICROSOFT), Property.builder("shape-rendering").isSvgOnly(), Property.builder("shape-image-threshold"), Property.builder("shape-margin"), Property.builder("shape-outside"), Property.builder("size"), Property.builder("speak-header"), Property.builder("speak-numeral"), Property.builder("speak-punctuation"), Property.builder("speak"), Property.builder("speech-rate"), Property.builder("src"), Property.builder("stop-color").isSvgOnly(), Property.builder("stop-opacity").isSvgOnly(), Property.builder("stress"), Property.builder("stroke").isSvgOnly(), Property.builder("stroke-dasharray").isSvgOnly(), Property.builder("stroke-dashoffset").isSvgOnly(), Property.builder("stroke-linecap").isSvgOnly(), Property.builder("stroke-linejoin").isSvgOnly(), Property.builder("stroke-miterlimit").isSvgOnly(), Property.builder("stroke-opacity").isSvgOnly(), Property.builder("stroke-width").isSvgOnly(), Property.builder("table-layout"), Property.builder("text-align"), Property.builder("text-anchor").isSvgOnly(), Property.builder("text-decoration"), Property.builder("text-decoration-color"), Property.builder("text-decoration-line"), Property.builder("text-decoration-skip"), Property.builder("text-decoration-style"), Property.builder("text-emphasis"), Property.builder("text-emphasis-color"), Property.builder("text-emphasis-position"), Property.builder("text-emphasis-style"), Property.builder("text-indent"), Property.builder("text-justify"), Property.builder("text-overflow"), Property.builder("text-rendering").isSvgOnly(), Property.builder("text-size-adjust"), Property.builder("text-shadow"), Property.builder("text-transform"), Property.builder("top"), Property.builder("touch-action"), Property.builder("transform"), Property.builder("transform-origin"), Property.builder("transform-style"), Property.builder("transition-delay"), Property.builder("transition-duration"), Property.builder("transition-property"), Property.builder("transition-timing-function"), Property.builder("transition"), Property.builder("unicode-bidi"), Property.builder("unicode-range"), Property.builder("user-select"), Property.builder("vector-effect").isSvgOnly(), Property.builder("vertical-align"), Property.builder("visibility"), Property.builder("voice-balance"), Property.builder("voice-duration"), Property.builder("voice-family"), Property.builder("voice-pitch"), Property.builder("voice-range"), Property.builder("voice-rate"), Property.builder("voice-stress"), Property.builder("voice-volume"), Property.builder("volume"), Property.builder("-webkit-align-content"), Property.builder("-webkit-align-items"), Property.builder("-webkit-align-self"), Property.builder("-webkit-animation"), Property.builder("-webkit-animation-delay"), Property.builder("-webkit-animation-direction"), Property.builder("-webkit-animation-duration"), Property.builder("-webkit-animation-fill-mode"), Property.builder("-webkit-animation-iteration-count"), Property.builder("-webkit-animation-name"), Property.builder("-webkit-animation-play-state"), Property.builder("-webkit-animation-timing-function"), Property.builder("-webkit-app-region"), Property.builder("-webkit-appearance"), Property.builder("-webkit-aspect-ratio"), Property.builder("-webkit-backface-visibility"), Property.builder("-webkit-background-clip"), Property.builder("-webkit-background-composite"), Property.builder("-webkit-background-origin"), Property.builder("-webkit-background-size"), Property.builder("-webkit-border-after"), Property.builder("-webkit-border-after-color"), Property.builder("-webkit-border-after-style"), Property.builder("-webkit-border-after-width"), Property.builder("-webkit-border-before"), Property.builder("-webkit-border-before-color"), Property.builder("-webkit-border-before-style"), Property.builder("-webkit-border-before-width"), Property.builder("-webkit-border-bottom-left-radius"), Property.builder("-webkit-border-bottom-right-radius"), Property.builder("-webkit-border-end"), Property.builder("-webkit-border-end-color"), Property.builder("-webkit-border-end-style"), Property.builder("-webkit-border-end-width"), Property.builder("-webkit-border-fit"), Property.builder("-webkit-border-horizontal-spacing"), Property.builder("-webkit-border-image"), Property.builder(WEBKIT_BORDER_RADIUS), Property.builder("-webkit-border-start"), Property.builder("-webkit-border-start-color"), Property.builder("-webkit-border-start-style"), Property.builder("-webkit-border-start-width"), Property.builder("-webkit-border-top-left-radius"), Property.builder("-webkit-border-top-right-radius"), Property.builder("-webkit-border-vertical-spacing"), Property.builder("-webkit-box-align"), Property.builder("-webkit-box-direction"), Property.builder("-webkit-box-flex"), Property.builder("-webkit-box-flex-group"), Property.builder("-webkit-box-lines"), Property.builder("-webkit-box-ordinal-group"), Property.builder("-webkit-box-orient"), Property.builder("-webkit-box-pack"), Property.builder("-webkit-box-reflect"), Property.builder("-webkit-box-shadow"), Property.builder("-webkit-box-sizing"), Property.builder("-webkit-clip-path"), Property.builder("-webkit-color-correction"), Property.builder("-webkit-column-axis"), Property.builder("-webkit-column-break-after"), Property.builder("-webkit-column-break-before"), Property.builder("-webkit-column-break-inside"), Property.builder("-webkit-column-count"), Property.builder("-webkit-column-gap"), Property.builder("-webkit-column-rule"), Property.builder("-webkit-column-rule-color"), Property.builder("-webkit-column-rule-style"), Property.builder("-webkit-column-rule-width"), Property.builder("-webkit-column-span"), Property.builder("-webkit-column-width"), Property.builder("-webkit-columns"), Property.builder("-webkit-cursor-visibility"), Property.builder("-webkit-dashboard-region"), Property.builder("-webkit-filter"), Property.builder("-webkit-flex"), Property.builder("-webkit-flex-align"), Property.builder("-webkit-flex-basis"), Property.builder("-webkit-flex-direction"), Property.builder("-webkit-flex-flow"), Property.builder("-webkit-flex-grow"), Property.builder("-webkit-flex-order"), Property.builder("-webkit-flex-pack"), Property.builder("-webkit-flex-shrink"), Property.builder("-webkit-flex-wrap"), Property.builder("-webkit-flow-from"), Property.builder("-webkit-flow-into"), Property.builder("-webkit-font-feature-settings"), Property.builder("-webkit-font-size-delta"), Property.builder("-webkit-font-smoothing"), Property.builder("-webkit-font-variant-ligatures"), Property.builder("-webkit-grid-columns"), Property.builder("-webkit-grid-rows"), Property.builder("-webkit-highlight"), Property.builder("-webkit-hyphenate-character"), Property.builder("-webkit-hyphenate-limit-after"), Property.builder("-webkit-hyphenate-limit-before"), Property.builder("-webkit-hyphenate-limit-lines"), Property.builder("-webkit-justify-content"), Property.builder("-webkit-line-box-contain"), Property.builder("-webkit-line-break"), Property.builder("-webkit-line-clamp"), Property.builder("-webkit-line-grid"), Property.builder("-webkit-line-grid-snap"), Property.builder("-webkit-locale"), Property.builder("-webkit-logical-height"), Property.builder("-webkit-logical-width"), Property.builder("-webkit-margin-after"), Property.builder("-webkit-margin-after-collapse"), Property.builder("-webkit-margin-before"), Property.builder("-webkit-margin-before-collapse"), Property.builder("-webkit-margin-bottom-collapse"), Property.builder("-webkit-margin-collapse"), Property.builder("-webkit-margin-end"), Property.builder("-webkit-margin-start"), Property.builder("-webkit-margin-top-collapse"), Property.builder("-webkit-marquee"), Property.builder("-webkit-marquee-direction"), Property.builder("-webkit-marquee-increment"), Property.builder("-webkit-marquee-repetition"), Property.builder("-webkit-marquee-speed"), Property.builder("-webkit-marquee-style"), Property.builder("-webkit-mask"), Property.builder("-webkit-mask-attachment"), Property.builder("-webkit-mask-box-image"), Property.builder("-webkit-mask-box-image-outset"), Property.builder("-webkit-mask-box-image-repeat"), Property.builder("-webkit-mask-box-image-slice"), Property.builder("-webkit-mask-box-image-source"), Property.builder("-webkit-mask-box-image-width"), Property.builder("-webkit-mask-clip"), Property.builder("-webkit-mask-composite"), Property.builder("-webkit-mask-image"), Property.builder("-webkit-mask-origin"), Property.builder("-webkit-mask-position"), Property.builder("-webkit-mask-position-x"), Property.builder("-webkit-mask-position-y"), Property.builder("-webkit-mask-repeat"), Property.builder("-webkit-mask-repeat-x"), Property.builder("-webkit-mask-repeat-y"), Property.builder("-webkit-mask-size"), Property.builder("-webkit-match-nearest-mail-blockquote-color"), Property.builder("-webkit-max-logical-height"), Property.builder("-webkit-max-logical-width"), Property.builder("-webkit-min-logical-height"), Property.builder("-webkit-min-logical-width"), Property.builder("-webkit-nbsp-mode"), Property.builder("-webkit-opacity"), Property.builder("-webkit-order"), Property.builder("-webkit-overflow-scrolling"), Property.builder("-webkit-padding-after"), Property.builder("-webkit-padding-before"), Property.builder("-webkit-padding-end"), Property.builder("-webkit-padding-start"), Property.builder("-webkit-perspective"), Property.builder("-webkit-perspective-origin"), Property.builder("-webkit-perspective-origin-x"), Property.builder("-webkit-perspective-origin-y"), Property.builder("-webkit-print-color-adjust"), Property.builder("-webkit-region-break-after"), Property.builder("-webkit-region-break-before"), Property.builder("-webkit-region-break-inside"), Property.builder("-webkit-region-overflow"), Property.builder("-webkit-rtl-ordering"), Property.builder("-webkit-svg-shadow"), Property.builder("-webkit-tap-highlight-color"), Property.builder("-webkit-text-decorations-in-effect"), Property.builder("-webkit-text-emphasis-position"), Property.builder("-webkit-text-fill-color"), Property.builder("-webkit-text-security"), Property.builder("-webkit-text-shadow"), Property.builder("-webkit-text-size-adjust"), Property.builder("-webkit-text-stroke"), Property.builder("-webkit-text-stroke-color"), Property.builder("-webkit-text-stroke-width"), Property.builder("-webkit-touch-callout"), Property.builder("-webkit-transform"), Property.builder("-webkit-transform-origin"), Property.builder("-webkit-transform-origin-x"), Property.builder("-webkit-transform-origin-y"), Property.builder("-webkit-transform-origin-z"), Property.builder("-webkit-transform-style"), Property.builder("-webkit-transition"), Property.builder("-webkit-transition-delay"), Property.builder("-webkit-transition-duration"), Property.builder("-webkit-transition-function"), Property.builder("-webkit-transition-property"), Property.builder("-webkit-transition-timing-function"), Property.builder("-webkit-user-drag"), Property.builder("-webkit-user-modify"), Property.builder("-webkit-user-select"), Property.builder("-webkit-wrap"), Property.builder("-webkit-wrap-flow"), Property.builder("-webkit-wrap-margin"), Property.builder("-webkit-wrap-padding"), Property.builder("-webkit-wrap-shape-inside"), Property.builder("-webkit-wrap-shape-outside"), Property.builder("-webkit-wrap-through"), Property.builder("-webkit-writing-mode"), Property.builder("white-space"), Property.builder("windows"), Property.builder("will-change"), Property.builder("width"), Property.builder("word-break"), Property.builder("word-spacing"), Property.builder("word-wrap"), Property.builder("writing-mode"), Property.builder("z-index"), Property.builder("zoom").setVendor(Vendor.MICROSOFT)});
        ImmutableBiMap.Builder allProperies = ImmutableBiMap.builder();
        for (Builder builder : recognizedProperties) {
            Property property = builder.build();
            allProperies.put((Object)property.getName(), (Object)property);
        }
        NAME_TO_PROPERTY_MAP = allProperies.build();
    }

    @VisibleForTesting
    static final class Builder {
        private final String name;
        private Set<String> shorthands;
        private Vendor vendor;
        private boolean hasPositionalParameters;
        private boolean isCustom;
        private boolean isSvgOnly;
        private String warning;
        private static final ImmutableSet<String> SHORTHAND_PROPERTIES = ImmutableSet.of((Object)"background", (Object)"border", (Object)"border-bottom", (Object)"border-color", (Object)"border-left", (Object)"border-right", (Object[])new String[]{"border-style", "border-top", "border-width", "font", "list-style", "margin", "outline", "padding", "pause"});
        private static final ImmutableSet<String> NO_SHORTHAND = ImmutableSet.of((Object)"border-collapse", (Object)"border-spacing");
        private static final ImmutableMap<String, String> BORDER_RADIUS_PROPERTIES = ImmutableMap.builder().put((Object)"border-radius", (Object)"border-radius").put((Object)"border-top-left-radius", (Object)"border-radius").put((Object)"border-top-right-radius", (Object)"border-radius").put((Object)"border-bottom-right-radius", (Object)"border-radius").put((Object)"border-bottom-left-radius", (Object)"border-radius").put((Object)"-webkit-border-radius", (Object)"-webkit-border-radius").put((Object)"-webkit-border-top-left-radius", (Object)"-webkit-border-radius").put((Object)"-webkit-border-top-right-radius", (Object)"-webkit-border-radius").put((Object)"-webkit-border-bottom-right-radius", (Object)"-webkit-border-radius").put((Object)"-webkit-border-bottom-left-radius", (Object)"-webkit-border-radius").put((Object)"-moz-border-radius", (Object)"-moz-border-radius").put((Object)"-moz-border-radius-topleft", (Object)"-moz-border-radius").put((Object)"-moz-border-radius-topright", (Object)"-moz-border-radius").put((Object)"-moz-border-radius-bottomright", (Object)"-moz-border-radius").put((Object)"-moz-border-radius-bottomleft", (Object)"-moz-border-radius").build();

        private Builder(String name) {
            Preconditions.checkNotNull((Object)name);
            this.name = name;
            this.shorthands = null;
            this.vendor = Vendor.parseProperty(name);
            this.hasPositionalParameters = false;
            this.isCustom = false;
            this.isSvgOnly = false;
            this.warning = null;
        }

        public Property build() {
            if (this.shorthands == null) {
                this.shorthands = Builder.computeShorthandPropertiesFor(this.name);
            }
            String partition = (String)Iterables.getFirst(this.shorthands, (Object)this.name);
            return new Property(this.name, this.shorthands, partition, this.vendor, this.hasPositionalParameters, this.isCustom, this.isSvgOnly, this.warning);
        }

        public Builder setVendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder setHasPositionalParameters(boolean hasPositionalParameters) {
            this.hasPositionalParameters = hasPositionalParameters;
            return this;
        }

        public Builder isCustom() {
            this.isCustom = true;
            return this;
        }

        public Builder isSvgOnly() {
            this.isSvgOnly = true;
            return this;
        }

        public Builder setShorthands(Set<String> shorthands) {
            this.shorthands = shorthands;
            return this;
        }

        public Builder warn(String warning) {
            this.warning = warning;
            return this;
        }

        private static ImmutableSet<String> computeShorthandPropertiesFor(String property) {
            if (NO_SHORTHAND.contains((Object)property)) {
                return ImmutableSet.of();
            }
            int lastHyphenIndex = property.lastIndexOf(45);
            if (lastHyphenIndex == -1) {
                return ImmutableSet.of();
            }
            if (BORDER_RADIUS_PROPERTIES.containsKey((Object)property)) {
                return ImmutableSet.of((Object)((String)BORDER_RADIUS_PROPERTIES.get((Object)property)));
            }
            String possibleShorthand = property.substring(0, lastHyphenIndex);
            if (!SHORTHAND_PROPERTIES.contains((Object)possibleShorthand)) {
                return ImmutableSet.of();
            }
            int butlastHyphenIndex = possibleShorthand.lastIndexOf(45);
            if (butlastHyphenIndex == -1) {
                return ImmutableSet.of((Object)possibleShorthand);
            }
            String smallestShorthand = property.substring(0, butlastHyphenIndex);
            if (!SHORTHAND_PROPERTIES.contains((Object)smallestShorthand)) {
                return ImmutableSet.of((Object)possibleShorthand);
            }
            Preconditions.checkArgument((boolean)smallestShorthand.equals(Property.BORDER));
            String otherShorthand = smallestShorthand + property.substring(lastHyphenIndex);
            Preconditions.checkArgument((boolean)SHORTHAND_PROPERTIES.contains((Object)otherShorthand), (String)"%s is not a shorthand property for %s", (Object)otherShorthand, (Object)property);
            return ImmutableSet.of((Object)smallestShorthand, (Object)possibleShorthand, (Object)otherShorthand);
        }
    }
}

