/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.gssfunctions;

import java.awt.Color;

class ColorUtil {
    static final int H = 0;
    static final int S = 1;
    static final int B = 2;
    static final int L = 2;

    static float[] toHsb(Color color) {
        return Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    static String formatColor(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    static Color hsbToColor(float[] inputHsb) {
        return Color.getHSBColor(inputHsb[0], inputHsb[1], inputHsb[2]);
    }

    static float[] hsbToHsl(float[] inputHsb) {
        float hHsb = inputHsb[0];
        float sHsb = inputHsb[1];
        float bHsb = inputHsb[2];
        float lHsl = bHsb * (2.0f - sHsb) / 2.0f;
        float sHsl = bHsb * sHsb / (1.0f - Math.abs(2.0f * lHsl - 1.0f));
        return new float[]{hHsb, sHsl, lHsl};
    }

    static float[] toHsl(Color color) {
        return ColorUtil.hsbToHsl(ColorUtil.toHsb(color));
    }

    static float[] hslToHsb(float[] inputHsl) {
        float hHsl = inputHsl[0];
        float sHsl = inputHsl[1];
        float lHsl = inputHsl[2];
        float hHsb = hHsl;
        float bHsb = (2.0f * lHsl + sHsl * (1.0f - Math.abs(2.0f * lHsl - 1.0f))) / 2.0f;
        float sHsb = 2.0f * (bHsb - lHsl) / bHsb;
        float[] hsb = new float[]{hHsb, sHsb, bHsb};
        return hsb;
    }

    static Color hslToColor(float[] inputHsl) {
        float[] hsb = ColorUtil.hslToHsb(inputHsl);
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    static boolean testContrast(Color color1, Color color2, float margin) {
        float differenceFraction = 1.0f - margin;
        return (float)ColorUtil.luminanceDiff(color1, color2) > 125.0f * differenceFraction && (float)ColorUtil.colorDiff(color1, color2) > 500.0f * differenceFraction;
    }

    static boolean testContrast(Color color1, Color color2) {
        return ColorUtil.luminanceDiff(color1, color2) > 125 && ColorUtil.colorDiff(color1, color2) > 500;
    }

    static int luminanceDiff(Color c1, Color c2) {
        return Math.abs(ColorUtil.luminance(c1) - ColorUtil.luminance(c2));
    }

    static int luminance(Color color) {
        return ColorUtil.luminance(color.getRed(), color.getGreen(), color.getBlue());
    }

    static int luminance(int red, int green, int blue) {
        return (red * 299 + green * 587 + blue * 114) / 1000;
    }

    static int colorDiff(Color color1, Color color2) {
        return ColorUtil.colorDiff(color1.getRed(), color1.getGreen(), color1.getBlue(), color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    static int colorDiff(int r1, int g1, int b1, int r2, int g2, int b2) {
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2);
    }

    private ColorUtil() {
    }
}

