/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.gssfunctions;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssHexColorNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.GssFunction;
import com.google.common.css.compiler.ast.GssFunctionException;
import com.google.common.css.compiler.gssfunctions.ColorParser;
import com.google.common.css.compiler.gssfunctions.ColorUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class GssFunctions {
    public static final String TRANSPARENT = "transparent";
    public static final String MUST_BE_NUMERIC = "The second argument must be a CssNumericNode";
    private static final String DECIMAL_FORMAT = "#.########";
    private static final DecimalFormatSymbols US_SYMBOLS = DecimalFormatSymbols.getInstance(Locale.US);
    private static final CharMatcher UNIT_MATCHER = new CharMatcher(){

        public boolean matches(char c) {
            return Character.isLetter(c) || c == '%';
        }

        public String toString() {
            return "GssFunctions.UNIT_MATCHER";
        }
    };

    public static Map<String, GssFunction> getFunctionMap() {
        return ImmutableMap.builder().put((Object)"add", (Object)new AddToNumericValue()).put((Object)"sub", (Object)new SubtractFromNumericValue()).put((Object)"mult", (Object)new Mult()).put((Object)"divide", (Object)new Div()).put((Object)"minimum", (Object)new MinValue()).put((Object)"maximum", (Object)new MaxValue()).put((Object)"blendColorsHsb", (Object)new BlendColorsHsb()).put((Object)"blendColorsRgb", (Object)new BlendColorsRgb()).put((Object)"makeMutedColor", (Object)new MakeMutedColor()).put((Object)"addHsbToCssColor", (Object)new AddHsbToCssColor()).put((Object)"makeContrastingColor", (Object)new MakeContrastingColor()).put((Object)"adjustBrightness", (Object)new AdjustBrightness()).put((Object)"makeTranslucent", (Object)new MakeTranslucent()).put((Object)"saturateColor", (Object)new SaturateColor()).put((Object)"desaturateColor", (Object)new DesaturateColor()).put((Object)"greyscale", (Object)new Greyscale()).put((Object)"lighten", (Object)new Lighten()).put((Object)"darken", (Object)new Darken()).put((Object)"spin", (Object)new Spin()).put((Object)"selectFrom", (Object)new SelectFrom()).put((Object)"concat", (Object)new Concat()).build();
    }

    public static boolean parseBoolean(String numericPart) {
        return Integer.parseInt(numericPart) == 1;
    }

    public static CssFunctionNode createUrlNode(String imageUrl, SourceCodeLocation location) {
        CssFunctionNode url = new CssFunctionNode(CssFunctionNode.Function.byName("url"), location);
        if (!imageUrl.equals("")) {
            CssLiteralNode argument = new CssLiteralNode(imageUrl, location);
            ImmutableList argList = ImmutableList.of((Object)argument);
            CssFunctionArgumentsNode arguments = new CssFunctionArgumentsNode((List<CssValueNode>)argList);
            url.setArguments(arguments);
        }
        return url;
    }

    public static void assertArgumentLooksLikeAColor(int argOrdinal, CssValueNode argValue, ErrorManager errorManager) throws GssFunctionException {
        CssFunctionNode functionNode;
        if (!(argValue instanceof CssHexColorNode || argValue instanceof CssLiteralNode || argValue instanceof CssFunctionNode)) {
            String message = String.format("Argument %d must be a CssHexColorNode. a CssLiteralNode, or a CssFunctionNode, was %s", argOrdinal, argValue.getClass().getSimpleName());
            errorManager.report(new GssError(message, argValue.getSourceCodeLocation()));
            throw new GssFunctionException(message);
        }
        if (argValue instanceof CssFunctionNode && !(functionNode = (CssFunctionNode)argValue).getFunctionName().equals("rgb") && !functionNode.getFunctionName().equals("rgba")) {
            String message = String.format("Could not interpret argument %d as a color. Function must be 'rgb' or 'rgba', was %s", argOrdinal, functionNode.getFunctionName());
            errorManager.report(new GssError(message, argValue.getSourceCodeLocation()));
            throw new GssFunctionException(message);
        }
    }

    public static GssFunctionException error(CssValueNode node, String errorMessage, ErrorManager errorManager) {
        return GssFunctions.error(errorMessage, errorManager, node.getSourceCodeLocation());
    }

    private static GssFunctionException error(String errorMessage, ErrorManager errorManager, SourceCodeLocation location) {
        if (errorManager != null) {
            errorManager.report(new GssError(errorMessage, location));
        }
        return new GssFunctionException(errorMessage);
    }

    private static void checkSize(String valueString, String unit, ErrorManager errorManager, SourceCodeLocation location, boolean isUnitOptional) throws GssFunctionException {
        double value;
        if (unit.equals("") && (value = Double.parseDouble(valueString)) != 0.0 && !isUnitOptional) {
            String message = "Size must be 0 or have a unit; was: " + valueString + unit;
            throw GssFunctions.error(message, errorManager, location);
        }
    }

    public static String createUrl(String url) {
        return CssFunctionNode.Function.byName("url") + "(" + url + ")";
    }

    public static class AddToNumericValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left + right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 0.0;
        }
    }

    public static class SubtractFromNumericValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left - right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 0.0;
        }
    }

    public static class Mult
    extends ScalarLeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left * right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 1.0;
        }
    }

    public static class Div
    extends ScalarLeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return left / right;
        }

        @Override
        protected boolean isIdentityValue(double value) {
            return value == 1.0;
        }
    }

    public static class MinValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return Math.min(left, right);
        }
    }

    public static class MaxValue
    extends LeftAssociativeOperator {
        @Override
        protected double performOperation(double left, double right) {
            return Math.max(left, right);
        }
    }

    public static class BlendColorsHsb
    extends BaseBlendColors {
        @Override
        public String blend(String startColorStr, String endColorStr) {
            Color midColor = BlendColorsHsb.blendHsb(ColorParser.parseAny(startColorStr), ColorParser.parseAny(endColorStr));
            return ColorUtil.formatColor(midColor);
        }

        private static Color blendHsb(Color startColor, Color endColor) {
            float midHue;
            float[] startColorHsb = ColorUtil.toHsb(startColor);
            float[] endColorHsb = ColorUtil.toHsb(endColor);
            float diffHue = Math.abs(startColorHsb[0] - endColorHsb[0]);
            float sumHue = startColorHsb[0] + endColorHsb[0];
            float f = midHue = (double)diffHue <= 0.5 ? sumHue / 2.0f : (sumHue + 1.0f) / 2.0f;
            if (midHue > 1.0f) {
                midHue -= 1.0f;
            }
            return Color.getHSBColor(midHue, (startColorHsb[1] + endColorHsb[1]) / 2.0f, (startColorHsb[2] + endColorHsb[2]) / 2.0f);
        }
    }

    public static class BlendColorsRgb
    extends BaseBlendColors {
        @Override
        public String blend(String startColorStr, String endColorStr) {
            Color startColor = ColorParser.parseAny(startColorStr);
            Color endColor = ColorParser.parseAny(endColorStr);
            Color midColor = new Color((startColor.getRed() + endColor.getRed()) / 2, (startColor.getGreen() + endColor.getGreen()) / 2, (startColor.getBlue() + endColor.getBlue()) / 2);
            return ColorUtil.formatColor(midColor);
        }
    }

    public static class MakeMutedColor
    implements GssFunction {
        private static final float LOSS_OF_SATURATION_FOR_MUTED_TONE = 0.2f;
        private static final String ARGUMENT_COUNT_ERROR_MESSAGE = "makeMutedColor expected arguments: backgroundColorStr, foregroundColorStr and an optional loss of saturation value (0 <= loss <= 1).";

        @Override
        public Integer getNumExpectedArguments() {
            return null;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.size() != 2 && args.size() != 3) {
                throw new GssFunctionException(ARGUMENT_COUNT_ERROR_MESSAGE);
            }
            CssValueNode backgroundColorNode = args.get(0);
            CssValueNode foregroundColorNode = args.get(1);
            String lossOfSaturationForMutedTone = String.valueOf(0.2f);
            if (args.size() == 3) {
                lossOfSaturationForMutedTone = args.get(2).getValue();
            }
            String backgroundColorStr = backgroundColorNode.getValue();
            String foregroundColorStr = foregroundColorNode.getValue();
            String resultStr = this.makeMutedColor(backgroundColorStr, foregroundColorStr, lossOfSaturationForMutedTone);
            CssHexColorNode result = new CssHexColorNode(resultStr, backgroundColorNode.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        protected String makeMutedColor(String backgroundColorStr, String foregroundColorStr, String lossStr) {
            if (GssFunctions.TRANSPARENT.equalsIgnoreCase(backgroundColorStr) || GssFunctions.TRANSPARENT.equalsIgnoreCase(foregroundColorStr)) {
                return foregroundColorStr;
            }
            Color backgroundColor = ColorParser.parseAny(backgroundColorStr);
            Color foregroundColor = ColorParser.parseAny(foregroundColorStr);
            float[] backgroundColorHsb = ColorUtil.toHsb(backgroundColor);
            float[] foregroundColorHsb = ColorUtil.toHsb(foregroundColor);
            float lossOfSaturationForMutedTone = Float.parseFloat(lossStr);
            if (lossOfSaturationForMutedTone < 0.0f) {
                lossOfSaturationForMutedTone = 0.0f;
            } else if (lossOfSaturationForMutedTone > 1.0f) {
                lossOfSaturationForMutedTone = 1.0f;
            }
            float mutedHue = foregroundColorHsb[0];
            float mutedSaturation = Math.max(foregroundColorHsb[1] - lossOfSaturationForMutedTone, 0.0f);
            float mutedBrightness = (foregroundColorHsb[2] + backgroundColorHsb[2]) / 2.0f;
            Color mutedColor = Color.getHSBColor(mutedHue, mutedSaturation, mutedBrightness);
            return ColorUtil.formatColor(mutedColor);
        }

        protected String makeMutedColor(String backgroundColorStr, String foregroundColorStr) {
            return this.makeMutedColor(backgroundColorStr, foregroundColorStr, String.valueOf(0.2f));
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            if (args.size() == 2) {
                return this.makeMutedColor(args.get(0), args.get(1));
            }
            if (args.size() == 3) {
                return this.makeMutedColor(args.get(0), args.get(1), args.get(2));
            }
            throw new GssFunctionException(ARGUMENT_COUNT_ERROR_MESSAGE);
        }
    }

    public static class AddHsbToCssColor
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 4;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            CssValueNode arg3 = args.get(2);
            CssValueNode arg4 = args.get(3);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode && arg3 instanceof CssNumericNode && arg4 instanceof CssNumericNode)) {
                String message = "Arguments number 2, 3 and 4 must be CssNumericNodes";
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            CssNumericNode numeric3 = (CssNumericNode)arg3;
            CssNumericNode numeric4 = (CssNumericNode)arg4;
            try {
                String resultString = this.addHsbToCssColor(args.get(0).getValue(), numeric2.getNumericPart(), numeric3.getNumericPart(), numeric4.getNumericPart());
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHsbToCssColor(baseColorString, args.get(1), args.get(2), args.get(3));
        }

        protected String addHsbToCssColor(String baseColorString, String hueToAdd, String saturationToAdd, String brightnessToAdd) throws GssFunctionException {
            try {
                return this.addHsbToCssColor(baseColorString, Integer.parseInt(hueToAdd), Integer.parseInt(saturationToAdd), Integer.parseInt(brightnessToAdd));
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Could not parse the " + (e instanceof NumberFormatException ? "integer arguments" : "color argument") + " for the function 'addHsbToCssColor'. The list of arguments was: %s, %s, %s, %s. ", baseColorString, hueToAdd, saturationToAdd, brightnessToAdd);
                throw new GssFunctionException(message);
            }
        }

        public String addHsbToCssColor(String baseColorString, int hueToAdd, int saturationToAdd, int brightnessToAdd) {
            if (GssFunctions.TRANSPARENT.equals(baseColorString)) {
                return baseColorString;
            }
            Color baseColor = ColorParser.parseAny(baseColorString);
            Color newColor = this.addValuesToHsbComponents(baseColor, hueToAdd, saturationToAdd, brightnessToAdd);
            return ColorUtil.formatColor(newColor);
        }

        public Color addValuesToHsbComponents(Color baseColor, int hueToAdd, int saturationToAdd, int brightnessToAdd) {
            float[] hsbValues = ColorUtil.toHsb(baseColor);
            hsbValues[0] = (float)((double)hsbValues[0] + (double)hueToAdd / 360.0);
            hsbValues[0] = hsbValues[0] - (float)Math.floor(hsbValues[0]);
            hsbValues[1] = (float)Math.min(1.0, Math.max(0.0, (double)hsbValues[1] + (double)saturationToAdd / 100.0));
            hsbValues[2] = (float)Math.min(1.0, Math.max(0.0, (double)hsbValues[2] + (double)brightnessToAdd / 100.0));
            return Color.getHSBColor(hsbValues[0], hsbValues[1], hsbValues[2]);
        }
    }

    public static class MakeContrastingColor
    implements GssFunction {
        private static final int NUM_ITERATIONS = 8;

        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String color = arg1.getValue();
            String similarity = arg2.toString();
            String resultStr = this.makeContrastingColor(color, similarity);
            CssHexColorNode result = new CssHexColorNode(resultStr, arg1.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.makeContrastingColor(args.get(0), args.get(1));
        }

        protected String makeContrastingColor(String inputColorStr, String similarityStr) {
            if (GssFunctions.TRANSPARENT.equalsIgnoreCase(inputColorStr)) {
                return inputColorStr;
            }
            Color inputColor = ColorParser.parseAny(inputColorStr);
            float similarity = Float.parseFloat(similarityStr);
            float[] distantColor = ColorUtil.toHsb(this.getDistantColor(inputColor, Color.BLACK, Color.WHITE));
            float[] startColor = ColorUtil.toHsb(inputColor);
            float[] endColor = distantColor;
            float[] closestContrastColor = null;
            for (int i = 0; i < 8; ++i) {
                closestContrastColor = this.blendSb(startColor, endColor, 0.5f);
                if (ColorUtil.testContrast(inputColor, ColorUtil.hsbToColor(closestContrastColor))) {
                    endColor = closestContrastColor;
                    continue;
                }
                startColor = closestContrastColor;
            }
            float[] resultColor = this.blendSb(closestContrastColor, distantColor, similarity);
            return ColorUtil.formatColor(ColorUtil.hsbToColor(resultColor));
        }

        private Color getDistantColor(Color color, Color first, Color second) {
            int secondLuminanceDiff;
            int firstLuminanceDiff = ColorUtil.luminanceDiff(color, first);
            return firstLuminanceDiff >= (secondLuminanceDiff = ColorUtil.luminanceDiff(color, second)) ? first : second;
        }

        private float[] blendSb(float[] keepHue, float[] other, float similarity) {
            float[] result = Arrays.copyOf(keepHue, keepHue.length);
            this.mix(1, keepHue, other, similarity, result);
            this.mix(2, keepHue, other, similarity, result);
            return result;
        }

        private void mix(int componentIdx, float[] sourceHsb, float[] otherColorHsb, float sourceSimilarity, float[] resultHsb) {
            resultHsb[componentIdx] = sourceHsb[componentIdx] * sourceSimilarity + otherColorHsb[componentIdx] * (1.0f - sourceSimilarity);
        }
    }

    public static class AdjustBrightness
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode originalColorNode = args.get(0);
            CssValueNode brightnessAmount = args.get(1);
            String originalColorStr = originalColorNode.getValue();
            String brightnessAmountStr = ((CssNumericNode)brightnessAmount).getNumericPart();
            String resultStr = this.adjustBrightness(originalColorStr, brightnessAmountStr);
            CssHexColorNode result = new CssHexColorNode(resultStr, originalColorNode.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        private float normalize(float value) {
            if ((double)value > 1.0) {
                return 1.0f;
            }
            if ((double)value < 0.0) {
                return 0.0f;
            }
            return value;
        }

        private String formatColorWithAdjustedBrightness(float[] originalHsb, float adjustedBrightness) {
            return ColorUtil.formatColor(Color.getHSBColor(originalHsb[0], originalHsb[1], adjustedBrightness));
        }

        protected String adjustBrightness(String originalColorStr, String brightnessStr) {
            if (GssFunctions.TRANSPARENT.equalsIgnoreCase(originalColorStr)) {
                return originalColorStr;
            }
            Color originalColor = ColorParser.parseAny(originalColorStr);
            float brightnessFloat = Float.parseFloat(brightnessStr) / 100.0f;
            float[] originalColorHsb = ColorUtil.toHsb(originalColor);
            float requestedBrightness = originalColorHsb[2] + brightnessFloat;
            if ((double)requestedBrightness >= 0.0 && (double)requestedBrightness <= 1.0) {
                return this.formatColorWithAdjustedBrightness(originalColorHsb, requestedBrightness);
            }
            requestedBrightness = this.normalize(requestedBrightness);
            float oppositeDirectionBrightness = this.normalize(originalColorHsb[2] - brightnessFloat);
            float chosenBrightness = Math.abs(brightnessFloat - (originalColorHsb[2] - requestedBrightness)) > Math.abs(brightnessFloat - (originalColorHsb[2] - oppositeDirectionBrightness)) ? oppositeDirectionBrightness : requestedBrightness;
            return this.formatColorWithAdjustedBrightness(originalColorHsb, chosenBrightness);
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.adjustBrightness(args.get(0), args.get(1));
        }
    }

    public static class MakeTranslucent
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String color = arg1.getValue();
            String alpha = arg2.toString();
            return ImmutableList.of((Object)this.makeTranslucent(color, alpha, arg1.getSourceCodeLocation()));
        }

        @Override
        public String getCallResultString(List<String> args) {
            return this.makeTranslucent(args.get(0), args.get(1), null).getValue();
        }

        protected CssValueNode makeTranslucent(String inputColorStr, String alphaStr, @Nullable SourceCodeLocation sourceCodeLocation) {
            Color inputColor = ColorParser.parseAny(inputColorStr);
            double alpha = Math.min(1.0, (double)Math.max(0.0f, Float.parseFloat(alphaStr)));
            float[] rgb = inputColor.getRGBColorComponents(null);
            Color outputColor = new Color(rgb[0], rgb[1], rgb[2], (float)alpha);
            ImmutableList argList = ImmutableList.of((Object)new CssLiteralNode(Integer.toString(outputColor.getRed()), sourceCodeLocation), (Object)new CssLiteralNode(Integer.toString(outputColor.getGreen()), sourceCodeLocation), (Object)new CssLiteralNode(Integer.toString(outputColor.getBlue()), sourceCodeLocation), (Object)new CssLiteralNode(new DecimalFormat("#.###", US_SYMBOLS).format((float)outputColor.getAlpha() / 255.0f), sourceCodeLocation));
            CssCompositeValueNode argsValue = new CssCompositeValueNode((List<CssValueNode>)argList, CssCompositeValueNode.Operator.COMMA, sourceCodeLocation);
            CssFunctionNode result = new CssFunctionNode(CssFunctionNode.Function.byName("rgba"), sourceCodeLocation);
            result.setArguments(new CssFunctionArgumentsNode((List<CssValueNode>)ImmutableList.of((Object)argsValue)));
            return result;
        }
    }

    public static class SaturateColor
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode)) {
                String message = GssFunctions.MUST_BE_NUMERIC;
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), "0", numeric2.getNumericPart(), "0");
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, "0", args.get(1), "0");
        }
    }

    public static class DesaturateColor
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode)) {
                String message = GssFunctions.MUST_BE_NUMERIC;
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), "0", "-" + numeric2.getNumericPart(), "0");
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, "0", "-" + args.get(1), "0");
        }
    }

    public static class Greyscale
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 1;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            if (!(arg1 instanceof CssHexColorNode) && !(arg1 instanceof CssLiteralNode)) {
                String message = "The argument must be a CssHexColorNode or a CssLiteralNode.";
                errorManager.report(new GssError(message, arg1.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), "0", "-100", "0");
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg1.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, "0", "-100", "0");
        }
    }

    public static class Lighten
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode)) {
                String message = GssFunctions.MUST_BE_NUMERIC;
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), "0", "0", numeric2.getNumericPart());
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, "0", "0", args.get(1));
        }
    }

    public static class Darken
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode)) {
                String message = GssFunctions.MUST_BE_NUMERIC;
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), "0", "0", "-" + numeric2.getNumericPart());
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, "0", "0", "-" + args.get(1));
        }
    }

    public static class Spin
    extends BaseHslColorManipulation
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            GssFunctions.assertArgumentLooksLikeAColor(1, arg1, errorManager);
            if (!(arg2 instanceof CssNumericNode)) {
                String message = GssFunctions.MUST_BE_NUMERIC;
                errorManager.report(new GssError(message, arg2.getSourceCodeLocation()));
                throw new GssFunctionException(message);
            }
            CssNumericNode numeric2 = (CssNumericNode)arg2;
            try {
                String resultString = this.addHslToCssColor(arg1.getValue(), numeric2.getNumericPart(), "0", "0");
                CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
                return ImmutableList.of((Object)result);
            }
            catch (GssFunctionException e) {
                errorManager.report(new GssError(e.getMessage(), arg2.getSourceCodeLocation()));
                throw e;
            }
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            String baseColorString = args.get(0);
            return this.addHslToCssColor(baseColorString, args.get(1), "0", "0");
        }
    }

    public static class SelectFrom
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 3;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            return ImmutableList.of((Object)("true".equals(args.get(0).getValue()) ? args.get(1) : args.get(2)));
        }

        @Override
        public String getCallResultString(List<String> args) {
            return "true".equals(args.get(0)) ? args.get(1) : args.get(2);
        }
    }

    public static class Concat
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return null;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            StringBuilder result = new StringBuilder();
            for (CssValueNode arg : args) {
                result.append(arg.getValue());
            }
            return ImmutableList.of((Object)new CssStringNode(CssStringNode.Type.SINGLE_QUOTED_STRING, result.toString()));
        }

        @Override
        public String getCallResultString(List<String> args) {
            StringBuilder result = new StringBuilder();
            for (String arg : args) {
                if (arg.length() > 1 && (arg.startsWith("'") && arg.endsWith("'") || arg.startsWith("\"") && arg.endsWith("\""))) {
                    result.append(CssStringNode.unescape(arg.substring(1, arg.length() - 1)));
                    continue;
                }
                result.append(arg);
            }
            return new CssStringNode(CssStringNode.Type.SINGLE_QUOTED_STRING, result.toString()).toString();
        }
    }

    private static final class Size {
        final String size;
        final String units;

        public Size(String size, String units) {
            this.size = size;
            this.units = units;
        }
    }

    private static abstract class ScalarLeftAssociativeOperator
    extends LeftAssociativeOperator {
        private ScalarLeftAssociativeOperator() {
        }

        @Override
        protected CssNumericNode calculate(List<CssNumericNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.isEmpty()) {
                throw GssFunctions.error("Not enough arguments", errorManager, args.get(0).getSourceCodeLocation());
            }
            double total = Double.parseDouble(args.get(0).getNumericPart());
            String overallUnit = args.get(0).getUnit();
            for (CssNumericNode node : args.subList(1, args.size())) {
                if (node.getUnit() != null && !node.getUnit().equals("")) {
                    throw GssFunctions.error("Only the first argument may have a unit associated with it,  but has unit: " + node.getUnit(), errorManager, node.getSourceCodeLocation());
                }
                double value = Double.parseDouble(node.getNumericPart());
                total = this.performOperation(total, value);
            }
            String resultString = new DecimalFormat(GssFunctions.DECIMAL_FORMAT, US_SYMBOLS).format(total);
            return new CssNumericNode(resultString, overallUnit != null ? overallUnit : "", args.get(0).getSourceCodeLocation());
        }
    }

    private static abstract class LeftAssociativeOperator
    implements GssFunction {
        private LeftAssociativeOperator() {
        }

        @Override
        public Integer getNumExpectedArguments() {
            return null;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) throws GssFunctionException {
            ArrayList numericList = Lists.newArrayList();
            for (CssValueNode arg : args) {
                numericList.add(LeftAssociativeOperator.getSizeNode(arg, errorManager, true));
            }
            return ImmutableList.of((Object)this.calculate(numericList, errorManager));
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            ArrayList numericList = Lists.newArrayList();
            for (String arg : args) {
                Size sizeWithUnits = LeftAssociativeOperator.parseSize(arg, true);
                numericList.add(new CssNumericNode(sizeWithUnits.size, sizeWithUnits.units));
            }
            CssNumericNode result = this.calculate(numericList, null);
            return result.getNumericPart() + result.getUnit();
        }

        protected CssNumericNode calculate(List<CssNumericNode> args, ErrorManager errorManager) throws GssFunctionException {
            if (args.size() < 2) {
                throw GssFunctions.error("Not enough arguments", errorManager, args.get(0).getSourceCodeLocation());
            }
            double total = Double.parseDouble(args.get(0).getNumericPart());
            String overallUnit = this.isIdentityValue(total) ? null : args.get(0).getUnit();
            for (CssNumericNode node : args.subList(1, args.size())) {
                double value = Double.parseDouble(node.getNumericPart());
                if (this.isIdentityValue(value)) continue;
                if (overallUnit == null) {
                    overallUnit = node.getUnit();
                } else if (!overallUnit.equals(node.getUnit())) {
                    throw GssFunctions.error("Parameters' units don't match (\"" + overallUnit + "\" vs \"" + node.getUnit() + "\")", errorManager, node.getSourceCodeLocation());
                }
                total = this.performOperation(total, value);
            }
            String resultString = new DecimalFormat(GssFunctions.DECIMAL_FORMAT, US_SYMBOLS).format(total);
            return new CssNumericNode(resultString, overallUnit != null ? overallUnit : "", args.get(0).getSourceCodeLocation());
        }

        protected abstract double performOperation(double var1, double var3);

        protected boolean isIdentityValue(double value) {
            return false;
        }

        private static CssNumericNode getSizeNode(CssValueNode valueNode, ErrorManager errorManager, boolean isUnitOptional) throws GssFunctionException {
            SourceCodeLocation location = valueNode.getSourceCodeLocation();
            if (valueNode instanceof CssNumericNode) {
                CssNumericNode node = (CssNumericNode)valueNode;
                GssFunctions.checkSize(node.getNumericPart(), node.getUnit(), errorManager, location, isUnitOptional);
                return node;
            }
            String message = "Size must be a CssNumericNode with a unit or 0; was: " + valueNode;
            throw GssFunctions.error(message, errorManager, location);
        }

        private static Size parseSize(String sizeWithUnits, boolean isUnitOptional) throws GssFunctionException {
            int unitIndex = UNIT_MATCHER.indexIn((CharSequence)sizeWithUnits);
            String size = unitIndex > 0 ? sizeWithUnits.substring(0, unitIndex) : sizeWithUnits;
            String units = unitIndex > 0 ? sizeWithUnits.substring(unitIndex) : "";
            GssFunctions.checkSize(size, units, null, null, isUnitOptional);
            return new Size(size, units);
        }
    }

    public static abstract class BaseHslColorManipulation {
        protected String addHslToCssColor(String baseColorString, String hueToAdd, String saturationToAdd, String lightnessToAdd) throws GssFunctionException {
            try {
                return this.addHslToCssColor(baseColorString, Integer.parseInt(hueToAdd), Integer.parseInt(saturationToAdd), Integer.parseInt(lightnessToAdd));
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Could not parse the " + (e instanceof NumberFormatException ? "integer arguments" : "color argument") + " for the function 'addHslToCssColor'. The list of arguments was: %s, %s, %s, %s. ", baseColorString, hueToAdd, saturationToAdd, lightnessToAdd);
                throw new GssFunctionException(message);
            }
        }

        protected String addHslToCssColor(String baseColorString, int hueToAdd, int saturationToAdd, int lightnessToAdd) {
            if (GssFunctions.TRANSPARENT.equals(baseColorString)) {
                return baseColorString;
            }
            Color baseColor = ColorParser.parseAny(baseColorString);
            Color newColor = this.addValuesToHslComponents(baseColor, hueToAdd, saturationToAdd, lightnessToAdd);
            return ColorUtil.formatColor(newColor);
        }

        private Color addValuesToHslComponents(Color baseColor, int hueToAdd, int saturationToAdd, int lightnessToAdd) {
            float[] hslValues = ColorUtil.toHsl(baseColor);
            hslValues[0] = (float)((double)hslValues[0] + (double)hueToAdd / 360.0);
            hslValues[0] = hslValues[0] - (float)Math.floor(hslValues[0]);
            hslValues[1] = (float)Math.min(1.0, Math.max(0.0, (double)hslValues[1] + (double)saturationToAdd / 100.0));
            hslValues[2] = (float)Math.min(1.0, Math.max(0.0, (double)hslValues[2] + (double)lightnessToAdd / 100.0));
            return ColorUtil.hslToColor(hslValues);
        }
    }

    public static abstract class BaseBlendColors
    implements GssFunction {
        @Override
        public Integer getNumExpectedArguments() {
            return 2;
        }

        @Override
        public List<CssValueNode> getCallResultNodes(List<CssValueNode> args, ErrorManager errorManager) {
            CssValueNode arg1 = args.get(0);
            CssValueNode arg2 = args.get(1);
            String startColorStr = arg1.getValue();
            String endColorStr = arg2.getValue();
            String resultString = this.blend(startColorStr, endColorStr);
            CssHexColorNode result = new CssHexColorNode(resultString, arg1.getSourceCodeLocation());
            return ImmutableList.of((Object)result);
        }

        @Override
        public String getCallResultString(List<String> args) throws GssFunctionException {
            try {
                return this.blend(args.get(0), args.get(1));
            }
            catch (IllegalArgumentException e) {
                throw new GssFunctionException("Colors could not be parsed", e);
            }
        }

        public abstract String blend(String var1, String var2);
    }

    static class ImageBackground {
        private static final String NO_REPEAT = "no-repeat";
        private final String url;
        private final String positionH;
        private final String positionHUnit;
        private final String positionV;
        private final String positionVUnit;

        public ImageBackground(String url, String cornerId, String imgSize, String units) {
            this.url = url;
            boolean isZero = Float.parseFloat(imgSize) == 0.0f;
            boolean isLeft = isZero || cornerId.endsWith("l");
            this.positionH = isLeft ? "0" : "-" + imgSize;
            this.positionHUnit = isLeft ? "" : units;
            boolean isTop = isZero || cornerId.startsWith("t");
            this.positionV = isTop ? "0" : "-" + imgSize;
            this.positionVUnit = isTop ? "" : units;
        }

        public String toString() {
            return GssFunctions.createUrl(this.url) + " no-repeat " + this.positionH + this.positionHUnit + " " + this.positionV + this.positionVUnit;
        }

        public List<CssValueNode> toNodes(SourceCodeLocation location) {
            return ImmutableList.of((Object)GssFunctions.createUrlNode(this.url, location), (Object)new CssLiteralNode(NO_REPEAT, location), (Object)new CssNumericNode(this.positionH, this.positionHUnit, location), (Object)new CssNumericNode(this.positionV, this.positionVUnit, location));
        }
    }
}

