/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.BrowserPrefixGenerator;
import com.google.common.css.compiler.passes.BrowserPrefixRule;
import java.util.ArrayList;

public class AutoExpandBrowserPrefix
extends DefaultTreeVisitor
implements CssCompilerPass {
    public static final String ALTERNATE = "/* @alternate */";
    private final MutatingVisitController visitController;
    private final ImmutableList<BrowserPrefixRule> expansionRules;
    private boolean inDefMixinBlock;

    public AutoExpandBrowserPrefix(MutatingVisitController visitController) {
        this.visitController = visitController;
        this.expansionRules = BrowserPrefixGenerator.getExpansionRules();
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        this.inDefMixinBlock = true;
        return true;
    }

    @Override
    public void leaveMixinDefinition(CssMixinDefinitionNode node) {
        this.inDefMixinBlock = false;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        if (this.inDefMixinBlock) {
            return true;
        }
        ImmutableList.Builder expansionNodes = ImmutableList.builder();
        for (BrowserPrefixRule rule : this.expansionRules) {
            ImmutableList replacements;
            if (rule.getMatchPropertyName() != null && !rule.getMatchPropertyName().equals(declaration.getPropertyName().getPropertyName())) continue;
            if (rule.getMatchPropertyValue() == null) {
                for (CssDeclarationNode ruleExpansionNode : rule.getExpansionNodes()) {
                    CssDeclarationNode expansionNode = ruleExpansionNode.deepCopy();
                    expansionNode.setPropertyValue(declaration.getPropertyValue().deepCopy());
                    expansionNode.setSourceCodeLocation(declaration.getSourceCodeLocation());
                    expansionNode.setComments(declaration.getComments());
                    expansionNode.appendComment(new CssCommentNode(ALTERNATE, null));
                    expansionNodes.add((Object)expansionNode);
                }
            } else if (!rule.isFunction()) {
                expansionNodes.addAll(this.getNonFunctionValueMatches(rule, declaration));
            } else if (AutoExpandBrowserPrefix.hasMatchingValueOnlyFunction(declaration, rule)) {
                expansionNodes.addAll(AutoExpandBrowserPrefix.expandMatchingValueOnlyFunctions(declaration, rule));
            } else {
                expansionNodes.addAll(this.getOtherMatches(declaration, rule));
            }
            if ((replacements = expansionNodes.build()).isEmpty()) continue;
            this.visitController.replaceCurrentBlockChildWith(replacements, false);
            break;
        }
        return true;
    }

    protected ImmutableList<CssDeclarationNode> getNonFunctionValueMatches(BrowserPrefixRule rule, CssDeclarationNode declaration) {
        CssDeclarationNode expansionNode;
        if (declaration.getPropertyValue().getChildren().size() != 1 || !rule.getMatchPropertyValue().equals(((CssValueNode)declaration.getPropertyValue().getChildAt(0)).getValue())) {
            return ImmutableList.of();
        }
        ImmutableList.Builder replacements = ImmutableList.builder();
        for (CssPropertyValueNode ruleValueNode : rule.getValueOnlyExpansionNodes()) {
            expansionNode = new CssDeclarationNode(declaration.getPropertyName(), ruleValueNode.deepCopy(), declaration.getSourceCodeLocation());
            expansionNode.appendComment(new CssCommentNode(ALTERNATE, null));
            replacements.add((Object)expansionNode);
        }
        for (CssDeclarationNode ruleExpansionNode : rule.getExpansionNodes()) {
            expansionNode = ruleExpansionNode.deepCopy();
            expansionNode.setSourceCodeLocation(declaration.getSourceCodeLocation());
            replacements.add((Object)expansionNode);
        }
        return replacements.build();
    }

    private ImmutableList<CssDeclarationNode> getOtherMatches(CssDeclarationNode declaration, BrowserPrefixRule rule) {
        CssValueNode matchValueNode = (CssValueNode)declaration.getPropertyValue().getChildAt(0);
        if (!(matchValueNode instanceof CssFunctionNode)) {
            return ImmutableList.of();
        }
        CssFunctionNode matchFunctionNode = (CssFunctionNode)matchValueNode;
        if (!matchFunctionNode.getFunctionName().equals(rule.getMatchPropertyValue())) {
            return ImmutableList.of();
        }
        ImmutableList.Builder replacements = ImmutableList.builder();
        for (CssDeclarationNode ruleExpansionNode : rule.getExpansionNodes()) {
            CssDeclarationNode expansionNode = ruleExpansionNode.deepCopy();
            CssValueNode expandValueNode = (CssValueNode)expansionNode.getPropertyValue().getChildAt(0);
            CssFunctionNode expandFunctionNode = (CssFunctionNode)expandValueNode;
            expandFunctionNode.setArguments(matchFunctionNode.getArguments().deepCopy());
            expansionNode.setSourceCodeLocation(declaration.getSourceCodeLocation());
            replacements.add((Object)expansionNode);
        }
        return replacements.build();
    }

    private static boolean matchesValueOnlyFunction(CssValueNode declarationValueNode, BrowserPrefixRule rule) {
        return declarationValueNode instanceof CssFunctionNode && ((CssFunctionNode)declarationValueNode).getFunctionName().equals(rule.getMatchPropertyValue());
    }

    private static boolean hasMatchingValueOnlyFunction(CssDeclarationNode declaration, BrowserPrefixRule rule) {
        if (rule.getValueOnlyExpansionNodes().isEmpty()) {
            return false;
        }
        for (CssValueNode declarationValueNode : declaration.getPropertyValue().getChildren()) {
            if (!AutoExpandBrowserPrefix.matchesValueOnlyFunction(declarationValueNode, rule)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableList<CssDeclarationNode> expandMatchingValueOnlyFunctions(CssDeclarationNode declaration, BrowserPrefixRule rule) {
        ImmutableList.Builder expansionNodes = ImmutableList.builder();
        for (CssPropertyValueNode ruleValueNode : rule.getValueOnlyExpansionNodes()) {
            ArrayList<CssValueNode> expansionNodeValues = new ArrayList<CssValueNode>(declaration.getPropertyValue().numChildren());
            for (CssValueNode declarationValueNode : declaration.getPropertyValue().getChildren()) {
                if (AutoExpandBrowserPrefix.matchesValueOnlyFunction(declarationValueNode, rule)) {
                    CssFunctionNode declarationFunctionNode = (CssFunctionNode)declarationValueNode;
                    CssFunctionNode expansionFunctionNode = (CssFunctionNode)((CssValueNode)ruleValueNode.getChildAt(0)).deepCopy();
                    expansionFunctionNode.setArguments(declarationFunctionNode.getArguments().deepCopy());
                    expansionNodeValues.add(expansionFunctionNode);
                    continue;
                }
                expansionNodeValues.add(declarationValueNode.deepCopy());
            }
            CssPropertyValueNode expansionValues = new CssPropertyValueNode(expansionNodeValues);
            CssDeclarationNode expansionNode = new CssDeclarationNode(declaration.getPropertyName(), expansionValues, declaration.getComments(), declaration.getSourceCodeLocation());
            expansionNode.appendComment(new CssCommentNode(ALTERNATE, null));
            expansionNodes.add((Object)expansionNode);
        }
        return expansionNodes.build();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

