/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssHexColorNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class BiDiFlipper
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final DecimalFormat PERCENT_FORMATTER = new DecimalFormat("#.########", DecimalFormatSymbols.getInstance(Locale.US));
    private final MutatingVisitController visitController;
    private final boolean shouldSwapLeftRightInUrl;
    private final boolean shouldSwapLtrRtlInUrl;
    private final boolean shouldFlipConstantReferences;
    public static final String RIGHT = "right";
    private static final Map<String, String> EXACT_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"ltr", (Object)"rtl").put((Object)"rtl", (Object)"ltr").put((Object)"left", (Object)"right").put((Object)"right", (Object)"left").put((Object)"e-resize", (Object)"w-resize").put((Object)"w-resize", (Object)"e-resize").put((Object)"ne-resize", (Object)"nw-resize").put((Object)"nw-resize", (Object)"ne-resize").put((Object)"nesw-resize", (Object)"nwse-resize").put((Object)"nwse-resize", (Object)"nesw-resize").put((Object)"se-resize", (Object)"sw-resize").put((Object)"sw-resize", (Object)"se-resize").build();
    private static final ImmutableMap<String, String> ENDS_WITH_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"-left", (Object)"-right").put((Object)"-right", (Object)"-left").put((Object)"-bottomleft", (Object)"-bottomright").put((Object)"-topleft", (Object)"-topright").put((Object)"-bottomright", (Object)"-bottomleft").put((Object)"-topright", (Object)"-topleft").build();
    private static final ImmutableMap<String, String> CONTAINS_MATCHING_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)"-left-", (Object)"-right-").put((Object)"-right-", (Object)"-left-").build();
    private static final ImmutableSet<String> PROPERTIES_WITH_FLIPPABLE_PERCENTAGE = ImmutableSet.of((Object)"background", (Object)"background-position", (Object)"background-position-x", (Object)"-ms-background-position-x");
    public static final ImmutableSet<String> BORDER_RADIUS_PROPERTIES = ImmutableSet.of((Object)"border-radius", (Object)"-webkit-border-radius", (Object)"-moz-border-radius");
    public static final ImmutableSet<String> FOUR_PART_PROPERTIES_THAT_SHOULD_FLIP = ImmutableSet.of((Object)"border-color", (Object)"border-style", (Object)"border-width", (Object)"margin", (Object)"padding");
    private static final ImmutableMap<Pattern, String> URL_LTRTL_PATTERN_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)Pattern.compile("(?<![a-zA-Z])([-_./]*)ltr([-_./]+)"), (Object)"$1rtl$2").put((Object)Pattern.compile("(?<![a-zA-Z])([-_./]*)rtl([-_./]+)"), (Object)"$1ltr$2").build();
    private static final ImmutableMap<Pattern, String> URL_LEFTRIGHT_PATTERN_FOR_FLIPPING = new ImmutableMap.Builder().put((Object)Pattern.compile("(?<![a-zA-Z])([-_./]*)left([-_./]+)"), (Object)"$1right$2").put((Object)Pattern.compile("(?<![a-zA-Z])([-_./]*)right([-_./]+)"), (Object)"$1left$2").build();

    public BiDiFlipper(MutatingVisitController visitController, boolean swapLtrRtlInUrl, boolean swapLeftRightInUrl, boolean shouldFlipConstantReferences) {
        this.visitController = visitController;
        this.shouldSwapLtrRtlInUrl = swapLtrRtlInUrl;
        this.shouldSwapLeftRightInUrl = swapLeftRightInUrl;
        this.shouldFlipConstantReferences = shouldFlipConstantReferences;
    }

    public BiDiFlipper(MutatingVisitController visitController, boolean swapLtrRtlInUrl, boolean swapLeftRightInUrl) {
        this(visitController, swapLtrRtlInUrl, swapLeftRightInUrl, false);
    }

    private static boolean isLeftOrCenterOrRight(String value) {
        return "left".equals(value) || "center".equals(value) || RIGHT.equals(value);
    }

    private static boolean isSlashNode(CssValueNode valueNode) {
        if (valueNode instanceof CssCompositeValueNode) {
            CssCompositeValueNode compositeNode = (CssCompositeValueNode)valueNode;
            return compositeNode.getOperator() == CssCompositeValueNode.Operator.SLASH;
        }
        return false;
    }

    private boolean shouldFlipConstantReference(CssValueNode valueNode) {
        if (!this.shouldFlipConstantReferences) {
            return false;
        }
        if (!(valueNode instanceof CssConstantReferenceNode)) {
            return false;
        }
        String ref = valueNode.getValue();
        return !ref.startsWith("__F");
    }

    private static boolean isNumericAndHasPercentage(CssValueNode value) {
        if (!(value instanceof CssNumericNode)) {
            return false;
        }
        CssNumericNode numericNode = (CssNumericNode)value;
        return "%".equals(numericNode.getUnit());
    }

    private static boolean isValidForPercentageFlipping(CssPropertyNode propertyNode, CssPropertyValueNode propertyValueNode, int valueIndex) {
        String propertyName = propertyNode.getPropertyName();
        if (PROPERTIES_WITH_FLIPPABLE_PERCENTAGE.contains((Object)propertyName)) {
            if (valueIndex == 0) {
                return true;
            }
            if ("background".equals(propertyName)) {
                CssValueNode previousValueNode = (CssValueNode)propertyValueNode.getChildAt(valueIndex - 1);
                return !(previousValueNode instanceof CssNumericNode) && !BiDiFlipper.isLeftOrCenterOrRight(previousValueNode.getValue());
            }
        }
        return false;
    }

    private CssValueNode flipPercentageValueNode(CssValueNode valueNode) {
        if (!BiDiFlipper.isNumericAndHasPercentage(valueNode)) {
            return valueNode;
        }
        CssNumericNode numericNode = (CssNumericNode)valueNode;
        String oldPercentageValue = numericNode.getNumericPart();
        return new CssNumericNode(BiDiFlipper.flipPercentageValue(oldPercentageValue), "%");
    }

    public static String flipPercentageValue(String value) {
        double newValue = 100.0 - Double.parseDouble(value);
        return PERCENT_FORMATTER.format(newValue);
    }

    private static List<CssValueNode> flipCorners(List<CssValueNode> valueNodes) {
        switch (valueNodes.size()) {
            case 2: {
                ArrayList<CssValueNode> flipped = new ArrayList<CssValueNode>(2);
                flipped.add(valueNodes.get(1));
                flipped.add(valueNodes.get(0));
                return flipped;
            }
            case 3: {
                ArrayList<CssValueNode> flipped = new ArrayList<CssValueNode>(4);
                flipped.add(valueNodes.get(1));
                flipped.add(valueNodes.get(0));
                flipped.add(valueNodes.get(1).deepCopy());
                flipped.add(valueNodes.get(2));
                return flipped;
            }
            case 4: {
                ArrayList<CssValueNode> flipped = new ArrayList<CssValueNode>(4);
                flipped.add(valueNodes.get(1));
                flipped.add(valueNodes.get(0));
                flipped.add(valueNodes.get(3));
                flipped.add(valueNodes.get(2));
                return flipped;
            }
        }
        return valueNodes;
    }

    private static List<CssValueNode> flipBorderRadius(List<CssValueNode> valueNodes) {
        int count = 0;
        int slashLocation = -1;
        CssCompositeValueNode slashNode = null;
        for (CssValueNode valueNode : valueNodes) {
            if (BiDiFlipper.isSlashNode(valueNode)) {
                slashLocation = count;
                slashNode = (CssCompositeValueNode)valueNode;
                break;
            }
            ++count;
        }
        if (slashLocation == -1) {
            return BiDiFlipper.flipCorners(valueNodes);
        }
        List<CssValueNode> slashNodeValues = slashNode.getValues();
        ArrayList<CssValueNode> horizontalValues = new ArrayList<CssValueNode>(valueNodes.subList(0, slashLocation));
        horizontalValues.add(slashNodeValues.get(0));
        List<CssValueNode> newHorizontalValues = BiDiFlipper.flipCorners(horizontalValues);
        ArrayList<CssValueNode> verticalValues = new ArrayList<CssValueNode>();
        verticalValues.add(slashNodeValues.get(1));
        verticalValues.addAll(valueNodes.subList(slashLocation + 1, valueNodes.size()));
        List<CssValueNode> newVerticalValues = BiDiFlipper.flipCorners(verticalValues);
        ArrayList<CssValueNode> newSlashNodeValues = new ArrayList<CssValueNode>();
        newSlashNodeValues.add(newHorizontalValues.get(newHorizontalValues.size() - 1));
        newSlashNodeValues.add(newVerticalValues.get(0));
        CssCompositeValueNode newSlashNode = new CssCompositeValueNode(newSlashNodeValues, CssCompositeValueNode.Operator.SLASH, null);
        ArrayList<CssValueNode> newValueList = new ArrayList<CssValueNode>(newHorizontalValues.subList(0, newHorizontalValues.size() - 1));
        newValueList.add(newSlashNode);
        newValueList.addAll(newVerticalValues.subList(1, newVerticalValues.size()));
        return newValueList;
    }

    private List<CssValueNode> flipNumericValues(List<CssValueNode> valueNodes, String propertyName) {
        if (BORDER_RADIUS_PROPERTIES.contains((Object)propertyName)) {
            return BiDiFlipper.flipBorderRadius(valueNodes);
        }
        if (valueNodes.size() != 4 || !FOUR_PART_PROPERTIES_THAT_SHOULD_FLIP.contains((Object)propertyName)) {
            return valueNodes;
        }
        int count = 0;
        CssValueNode secondValueNode = null;
        CssValueNode fourthValueNode = null;
        for (CssValueNode valueNode : valueNodes) {
            if (valueNode instanceof CssNumericNode || valueNode instanceof CssLiteralNode || valueNode instanceof CssHexColorNode || this.shouldFlipConstantReference(valueNode)) {
                switch (count) {
                    case 3: {
                        fourthValueNode = valueNode.deepCopy();
                        break;
                    }
                    case 1: {
                        secondValueNode = valueNode.deepCopy();
                        break;
                    }
                }
            } else {
                return valueNodes;
            }
            ++count;
        }
        count = 0;
        ArrayList<CssValueNode> newValueList = new ArrayList<CssValueNode>();
        for (CssValueNode valueNode : valueNodes) {
            if (1 == count) {
                newValueList.add(fourthValueNode);
            } else if (3 == count) {
                newValueList.add(secondValueNode);
            } else {
                newValueList.add(valueNode);
            }
            ++count;
        }
        return newValueList;
    }

    public static String flipLiteralValue(String value) {
        value = EXACT_MATCHING_FOR_FLIPPING.getOrDefault(value, value);
        for (Map.Entry entry : ENDS_WITH_MATCHING_FOR_FLIPPING.entrySet()) {
            if (!value.endsWith((String)entry.getKey())) continue;
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            break;
        }
        for (Map.Entry entry : CONTAINS_MATCHING_FOR_FLIPPING.entrySet()) {
            if (!value.contains((CharSequence)entry.getKey())) continue;
            value = value.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            break;
        }
        return value;
    }

    protected <T extends CssValueNode> T flipNode(T tNode) {
        if (tNode instanceof CssLiteralNode) {
            CssLiteralNode literalNode = (CssLiteralNode)tNode;
            String oldValue = literalNode.getValue();
            if (oldValue == null) {
                return tNode;
            }
            String flippedValue = BiDiFlipper.flipLiteralValue(oldValue);
            if (oldValue.equals(flippedValue)) {
                return tNode;
            }
            CssLiteralNode flippedLiteralNode = new CssLiteralNode(flippedValue);
            return (T)flippedLiteralNode;
        }
        if (tNode instanceof CssPropertyNode) {
            CssPropertyNode propertyNode = (CssPropertyNode)tNode;
            String oldValue = propertyNode.getPropertyName();
            if (oldValue == null) {
                return tNode;
            }
            String flippedValue = BiDiFlipper.flipLiteralValue(oldValue);
            if (oldValue.equals(flippedValue)) {
                return tNode;
            }
            CssPropertyNode flippedPropertyNode = new CssPropertyNode(flippedValue);
            return (T)flippedPropertyNode;
        }
        return tNode;
    }

    private String flipUrlValue(String value) {
        String s;
        if (value == null) {
            return null;
        }
        if (this.shouldSwapLtrRtlInUrl) {
            for (Pattern p : URL_LTRTL_PATTERN_FOR_FLIPPING.keySet()) {
                if (!p.matcher(value).find()) continue;
                s = (String)URL_LTRTL_PATTERN_FOR_FLIPPING.get((Object)p);
                value = p.matcher(value).replaceFirst(s);
                break;
            }
        }
        if (this.shouldSwapLeftRightInUrl) {
            for (Pattern p : URL_LEFTRIGHT_PATTERN_FOR_FLIPPING.keySet()) {
                if (!p.matcher(value).find()) continue;
                s = (String)URL_LEFTRIGHT_PATTERN_FOR_FLIPPING.get((Object)p);
                value = p.matcher(value).replaceFirst(s);
                break;
            }
        }
        return value;
    }

    private CssValueNode flipUrlNode(CssValueNode valueNode) {
        if (!(valueNode instanceof CssFunctionNode) || !"url".equals(((CssFunctionNode)valueNode).getFunctionName())) {
            return valueNode;
        }
        CssFunctionNode oldFunctionNode = (CssFunctionNode)valueNode;
        CssFunctionArgumentsNode functionArguments = oldFunctionNode.getArguments();
        Preconditions.checkArgument((1 == functionArguments.numChildren() ? 1 : 0) != 0, (Object)"url function taking more than one argument");
        CssValueNode oldArgument = (CssValueNode)functionArguments.getChildAt(0);
        String oldUrlValue = oldArgument.getValue();
        String newUrlValue = this.flipUrlValue(oldUrlValue);
        CssValueNode newArgument = oldArgument.deepCopy();
        newArgument.setValue(newUrlValue);
        ArrayList<CssValueNode> newArgumentsList = new ArrayList<CssValueNode>();
        newArgumentsList.add(newArgument);
        CssFunctionNode newFunctionNode = oldFunctionNode.deepCopy();
        newFunctionNode.setArguments(new CssFunctionArgumentsNode(newArgumentsList));
        return newFunctionNode;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declarationNode) {
        if (!declarationNode.getShouldBeFlipped()) {
            return true;
        }
        CssDeclarationNode newDeclarationNode = declarationNode.deepCopy();
        CssPropertyNode propertyNode = declarationNode.getPropertyName();
        newDeclarationNode.setPropertyName(this.flipNode(propertyNode));
        CssPropertyValueNode propertyValueNode = declarationNode.getPropertyValue();
        List<CssValueNode> valueNodes = new ArrayList<CssValueNode>();
        int valueIndex = 0;
        for (CssValueNode valueNode : propertyValueNode.childIterable()) {
            CssValueNode temp = this.flipUrlNode(valueNode);
            temp = this.flipNode(temp);
            if (BiDiFlipper.isValidForPercentageFlipping(propertyNode, propertyValueNode, valueIndex)) {
                temp = this.flipPercentageValueNode(temp);
            }
            valueNodes.add(temp.deepCopy());
            ++valueIndex;
        }
        if (!valueNodes.isEmpty()) {
            CssValueNode priority = null;
            if (Iterables.getLast(valueNodes) instanceof CssPriorityNode) {
                priority = (CssValueNode)Iterables.getLast(valueNodes);
                valueNodes = valueNodes.subList(0, valueNodes.size() - 1);
            }
            List<CssValueNode> newValueList = this.flipNumericValues(valueNodes, propertyNode.getPropertyName());
            if (priority != null) {
                newValueList.add(priority);
            }
            newDeclarationNode.setPropertyValue(new CssPropertyValueNode(newValueList));
        } else {
            newDeclarationNode.setPropertyValue(propertyValueNode.deepCopy());
        }
        ArrayList<CssDeclarationNode> replacementList = new ArrayList<CssDeclarationNode>();
        replacementList.add(newDeclarationNode);
        this.visitController.replaceCurrentBlockChildWith(replacementList, false);
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

