/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BrowserPrefixRule {
    private final Optional<String> matchPropertyName;
    private final Optional<String> matchPropertyValue;
    private final boolean isFunction;
    private final List<CssDeclarationNode> expansionNodes = Lists.newArrayList();
    private final List<CssPropertyValueNode> valueOnlyExpansionNodes = Lists.newArrayList();

    private BrowserPrefixRule(Builder builder) {
        CssDeclarationNode node;
        Preconditions.checkState((builder.matchPropertyName != null || builder.matchPropertyValue != null ? 1 : 0) != 0);
        this.matchPropertyName = Optional.ofNullable(builder.matchPropertyName);
        this.matchPropertyValue = Optional.ofNullable(builder.matchPropertyValue);
        this.isFunction = builder.isFunction;
        if (builder.expandPropertyValueList.isEmpty()) {
            Preconditions.checkState((!builder.expandPropertyNameList.isEmpty() ? 1 : 0) != 0);
            for (String propertyName : builder.expandPropertyNameList) {
                CssPropertyNode propertyNode = new CssPropertyNode(propertyName);
                CssPropertyValueNode valueNode = new CssPropertyValueNode();
                node = new CssDeclarationNode(propertyNode, valueNode);
                node.appendComment(new CssCommentNode("/* @alternate */", null));
                this.expansionNodes.add(node);
            }
        }
        if (builder.expandPropertyNameList.isEmpty()) {
            Preconditions.checkState((!builder.expandPropertyValueList.isEmpty() ? 1 : 0) != 0);
            for (String propertyValue : builder.expandPropertyValueList) {
                CssPropertyValueNode valueNode = new CssPropertyValueNode();
                if (this.isFunction) {
                    Preconditions.checkState((!builder.expandPropertyValueList.isEmpty() ? 1 : 0) != 0);
                    CssFunctionNode functionNode = new CssFunctionNode(CssFunctionNode.Function.byName(propertyValue), null);
                    valueNode.addChildToBack(functionNode);
                } else {
                    Preconditions.checkState((boolean)this.matchPropertyValue.isPresent());
                    valueNode.addChildToBack(new CssLiteralNode(propertyValue));
                }
                if (this.matchPropertyName.isPresent()) {
                    CssPropertyNode propertyNode = new CssPropertyNode(this.matchPropertyName.get());
                    node = new CssDeclarationNode(propertyNode, valueNode);
                    node.appendComment(new CssCommentNode("/* @alternate */", null));
                    this.expansionNodes.add(node);
                    continue;
                }
                this.valueOnlyExpansionNodes.add(valueNode);
            }
        }
    }

    @Nullable
    public String getMatchPropertyName() {
        return this.matchPropertyName.orElse(null);
    }

    @Nullable
    public String getMatchPropertyValue() {
        return this.matchPropertyValue.orElse(null);
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public List<CssDeclarationNode> getExpansionNodes() {
        return this.expansionNodes;
    }

    List<CssPropertyValueNode> getValueOnlyExpansionNodes() {
        return this.valueOnlyExpansionNodes;
    }

    static class Builder {
        @Nullable
        private String matchPropertyName = null;
        @Nullable
        private String matchPropertyValue = null;
        final List<String> expandPropertyNameList = Lists.newArrayList();
        final List<String> expandPropertyValueList = Lists.newArrayList();
        private boolean isFunction = false;

        Builder() {
        }

        Builder matchPropertyName(String propertyName) {
            this.matchPropertyName = propertyName;
            return this;
        }

        Builder matchPropertyValue(String propertyValue) {
            this.matchPropertyValue = propertyValue;
            return this;
        }

        Builder isFunction(boolean isFunction) {
            this.isFunction = isFunction;
            return this;
        }

        Builder addExpandPropertyName(String propertyName) {
            this.expandPropertyNameList.add(propertyName);
            return this;
        }

        Builder addExpandPropertyValue(String propertyValue) {
            this.expandPropertyValueList.add(propertyValue);
            return this;
        }

        BrowserPrefixRule build() {
            return new BrowserPrefixRule(this);
        }
    }
}

