/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssMixinNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CheckMissingRequire
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final Logger logger = Logger.getLogger(CheckMissingRequire.class.getName());
    private static final Pattern OVERRIDE_SELECTOR_REGEX = Pattern.compile("^\\s*(?:/\\*?)?\\*\\s+@overrideSelector\\s+\\{(.*)}\\s*(?:\\*/)?$", 8);
    private static final Pattern OVERRIDE_DEF_REGEX = Pattern.compile("^\\s*(?:/\\*?)?\\*\\s+@overrideDef\\s+\\{(.*)}\\s*(?:\\*/)?$", 8);
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private final Map<String, String> filenameProvideMap;
    private final ListMultimap<String, String> filenameRequireMap;
    private final ListMultimap<String, String> defProvideMap;
    private final ListMultimap<String, String> defmixinProvideMap;

    public CheckMissingRequire(VisitController visitController, ErrorManager errorManager, Map<String, String> filenameProvideMap, ListMultimap<String, String> filenameRequireMap, ListMultimap<String, String> defProvideMap, ListMultimap<String, String> defmixinProvideMap) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.filenameProvideMap = filenameProvideMap;
        this.filenameRequireMap = filenameRequireMap;
        this.defProvideMap = defProvideMap;
        this.defmixinProvideMap = defmixinProvideMap;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssConstantReferenceNode) {
            CssConstantReferenceNode reference = (CssConstantReferenceNode)node;
            String filename = reference.getSourceCodeLocation().getSourceCode().getFileName();
            List provides = this.defProvideMap.get((Object)reference.getValue());
            if (this.hasMissingRequire(provides, this.filenameProvideMap.get(filename), this.filenameRequireMap.get((Object)filename))) {
                StringBuilder error = new StringBuilder("Missing @require for constant " + reference.getValue() + ". Please @require namespace from:\n");
                for (String namespace : this.defProvideMap.get((Object)reference.getValue())) {
                    error.append("\t");
                    error.append(namespace);
                    error.append("\n");
                }
                this.errorManager.report(new GssError(error.toString(), reference.getSourceCodeLocation()));
            }
        }
        return true;
    }

    @Override
    public boolean enterMixin(CssMixinNode node) {
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        List provides = this.defmixinProvideMap.get((Object)node.getDefinitionName());
        if (this.hasMissingRequire(provides, this.filenameProvideMap.get(filename), this.filenameRequireMap.get((Object)filename))) {
            StringBuilder error = new StringBuilder("Missing @require for mixin " + node.getDefinitionName() + ". Please @require namespace from:\n");
            for (String namespace : this.defmixinProvideMap.get((Object)node.getDefinitionName())) {
                error.append("\t");
                error.append(namespace);
                error.append("\n");
            }
            this.errorManager.report(new GssError(error.toString(), node.getSourceCodeLocation()));
        }
        return true;
    }

    private boolean hasMissingRequire(List<String> provides, String currentNamespace, List<String> requires) {
        HashSet defNamespaceSet = Sets.newHashSet(provides);
        HashSet requireNamespaceSet = Sets.newHashSet(requires);
        requireNamespaceSet.retainAll(defNamespaceSet);
        return requireNamespaceSet.isEmpty() && !defNamespaceSet.contains(currentNamespace);
    }

    @Override
    public boolean enterSelector(CssSelectorNode node) {
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        for (CssRefinerNode refiner : node.getRefiners().getChildren()) {
            for (CssCommentNode comment : refiner.getComments()) {
                Matcher matcher = OVERRIDE_SELECTOR_REGEX.matcher(comment.getValue());
                if (!this.match(matcher, filename, "overrideSelector", node.getSourceCodeLocation())) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        for (CssCommentNode comment : node.getComments()) {
            Matcher matcher = OVERRIDE_DEF_REGEX.matcher(comment.getValue());
            if (!this.match(matcher, filename, "overrideDef", node.getSourceCodeLocation())) continue;
            return true;
        }
        return true;
    }

    private boolean match(Matcher matcher, String filename, String override, SourceCodeLocation node) {
        if (matcher.find()) {
            String overrideNamespace = matcher.group(1);
            List requires = this.filenameRequireMap.get((Object)filename);
            HashSet requireNamespaceSet = Sets.newHashSet((Iterable)requires);
            if (!requireNamespaceSet.contains(overrideNamespace)) {
                String error = "Missing @require for @" + override + " {" + overrideNamespace + "}. Please @require this namespace in file: " + filename + ".\n";
                this.errorManager.report(new GssError(error, node));
                return true;
            }
        }
        return false;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

