/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class CodeBuffer {
    private final StringBuilder sb = new StringBuilder();
    private int nextCharIndex;
    private int nextLineIndex;
    private int lastCharIndex;

    public CodeBuffer() {
        this.resetIndex();
    }

    public final String getOutput() {
        return this.sb.toString();
    }

    public final int getCurrentLength() {
        return this.sb.length();
    }

    public final char getLastChar() {
        return this.sb.charAt(this.sb.length() - 1);
    }

    public final int getNextCharIndex() {
        return this.nextCharIndex;
    }

    public final int getNextLineIndex() {
        return this.nextLineIndex;
    }

    public final int getLastCharIndex() {
        return this.lastCharIndex;
    }

    public final int getLastLineIndex() {
        return this.nextLineIndex - (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) == '\n' ? 1 : 0);
    }

    public final CodeBuffer append(@Nullable String str) {
        if (str == null) {
            return this;
        }
        if (str.length() == 1) {
            this.append(str.charAt(0));
        } else {
            String[] parts = str.split("\n", -1);
            for (int i = 0; i < parts.length; ++i) {
                this.sb.append(parts[i]);
                this.incrementIndexBy(parts[i].length());
                if (i == parts.length - 1) continue;
                this.startNewLine();
            }
        }
        return this;
    }

    public final CodeBuffer append(char c) {
        if (c == '\n') {
            this.startNewLine();
        } else {
            this.sb.append(c);
            this.incrementIndexBy(1);
        }
        return this;
    }

    public final CodeBuffer append(Object o) {
        this.append(o.toString());
        return this;
    }

    public final CodeBuffer startNewLine() {
        this.sb.append('\n');
        this.incrementIndexForNewline();
        return this;
    }

    public final CodeBuffer deleteLastChar() {
        if (this.getCurrentLength() > 0) {
            this.decrementIndex();
            this.sb.deleteCharAt(this.getCurrentLength() - 1);
        }
        return this;
    }

    public final CodeBuffer deleteLastChars(int n) {
        for (int i = 0; i < n; ++i) {
            this.deleteLastChar();
        }
        return this;
    }

    public final CodeBuffer reset() {
        this.resetIndex();
        this.sb.setLength(0);
        this.sb.trimToSize();
        return this;
    }

    public void deleteLastCharIfCharIs(char ch) {
        if (this.getCurrentLength() > 0 && this.getLastChar() == ch) {
            this.deleteLastChar();
        }
    }

    public void deleteEndingIfEndingIs(String s) {
        if (this.sb.subSequence(this.sb.length() - s.length(), this.sb.length()).equals(s)) {
            this.deleteLastChars(s.length());
        }
    }

    private void incrementIndexBy(int step) {
        if (step > 0) {
            this.lastCharIndex = this.nextCharIndex + step - 1;
            this.nextCharIndex += step;
        }
    }

    private void incrementIndexForNewline() {
        this.lastCharIndex = this.nextCharIndex;
        this.nextCharIndex = 0;
        ++this.nextLineIndex;
    }

    private void decrementIndex() {
        int lastNewline;
        int secondToLastNewLine;
        Preconditions.checkState((this.getCurrentLength() > 0 ? 1 : 0) != 0);
        this.nextCharIndex = this.lastCharIndex;
        int lastIndex = this.getCurrentLength() - 1;
        if (this.sb.charAt(lastIndex) == '\n') {
            --this.nextLineIndex;
        }
        this.lastCharIndex = lastIndex - 1 > 0 && this.sb.charAt(lastIndex - 1) == '\n' ? ((secondToLastNewLine = this.sb.substring(0, (lastNewline = this.sb.lastIndexOf("\n")) - 1).lastIndexOf(10)) == -1 ? lastNewline - 1 : lastNewline - secondToLastNewLine - 1) : --this.lastCharIndex;
    }

    private void resetIndex() {
        this.nextCharIndex = 0;
        this.nextLineIndex = 0;
        this.lastCharIndex = -1;
    }
}

