/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.DelegatingVisitor;
import com.google.common.css.compiler.passes.GssSourceMapGenerator;
import com.google.common.css.compiler.passes.UniformVisitor;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class CodePrinter
implements CssCompilerPass {
    private final VisitController visitController;
    private final CodeBuffer buffer;
    private final GssSourceMapGenerator generator;
    private boolean preserveMarkedComments;
    private static final Pattern LICENSE_ANNOTATION_PATTERN = Pattern.compile(".*@license\\b.*", 32);
    private static final Pattern PRESERVE_ANNOTATION_PATTERN = Pattern.compile(".*@preserve\\b.*", 32);
    private static final Pattern IMPORTANT_ANNOTATION_PATTERN = Pattern.compile("/\\*!.*", 32);
    private static final String END_OF_LICENSED_CSS_FILE = "/* END OF LICENSED CSS FILE */\n";

    protected CodePrinter(VisitController visitController, @Nullable CodeBuffer buffer, @Nullable GssSourceMapGenerator generator) {
        this.visitController = visitController;
        this.buffer = buffer != null ? buffer : new CodeBuffer();
        this.generator = generator;
    }

    protected abstract CssTreeVisitor createVisitor(VisitController var1, CodeBuffer var2);

    protected final void visit() {
        LinkedList<CssTreeVisitor> visitors = new LinkedList<CssTreeVisitor>();
        if (this.generator != null) {
            visitors.add(UniformVisitor.Adapters.asVisitor(new SourceMapVisitor()));
        }
        if (this.preserveMarkedComments) {
            visitors.add(UniformVisitor.Adapters.asVisitor(new CommentPrintingVisitor()));
        }
        visitors.add(this.createVisitor(this.visitController, this.buffer));
        this.visitController.startVisit(DelegatingVisitor.from(visitors));
    }

    protected final void resetBuffer() {
        this.buffer.reset();
    }

    protected final String getOutputBuffer() {
        return this.buffer.getOutput();
    }

    public void setPreserveMarkedComments(boolean preserveMarkedComments) {
        this.preserveMarkedComments = preserveMarkedComments;
    }

    private class SourceMapVisitor
    implements UniformVisitor {
        private SourceMapVisitor() {
        }

        @Override
        public void enter(CssNode node) {
            CodePrinter.this.generator.startSourceMapping(node, CodePrinter.this.buffer.getNextLineIndex(), CodePrinter.this.buffer.getNextCharIndex());
        }

        @Override
        public void leave(CssNode node) {
            CodePrinter.this.generator.endSourceMapping(node, CodePrinter.this.buffer.getLastLineIndex(), CodePrinter.this.buffer.getLastCharIndex());
        }
    }

    private class CommentPrintingVisitor
    implements UniformVisitor {
        private final LastLicenseData lastLicenseData = new LastLicenseData();

        private CommentPrintingVisitor() {
        }

        @Override
        public void enter(CssNode node) {
            String newSourceLocation = this.fileNameForSourceCodeLocation(node.getSourceCodeLocation());
            if (this.lastLicenseData.source != null && newSourceLocation != null && !this.lastLicenseData.source.equals(newSourceLocation)) {
                CodePrinter.this.buffer.append(CodePrinter.END_OF_LICENSED_CSS_FILE);
                this.lastLicenseData.source = null;
            }
            if (!node.getComments().isEmpty()) {
                boolean hasLicense = false;
                StringBuilder commentBuffer = new StringBuilder();
                for (CssCommentNode c : node.getComments()) {
                    boolean currentHasLicense = LICENSE_ANNOTATION_PATTERN.matcher(c.getValue()).matches();
                    hasLicense |= currentHasLicense;
                    if (!currentHasLicense && !PRESERVE_ANNOTATION_PATTERN.matcher(c.getValue()).matches() && !IMPORTANT_ANNOTATION_PATTERN.matcher(c.getValue()).matches()) continue;
                    commentBuffer.append(c.getValue());
                }
                String comment = commentBuffer.toString();
                if (!comment.isEmpty()) {
                    if (hasLicense && comment.equals(this.lastLicenseData.content)) {
                        CodePrinter.this.buffer.deleteEndingIfEndingIs(CodePrinter.END_OF_LICENSED_CSS_FILE);
                    } else {
                        CodePrinter.this.buffer.startNewLine();
                        CodePrinter.this.buffer.append(comment);
                        CodePrinter.this.buffer.startNewLine();
                        this.lastLicenseData.content = null;
                    }
                    if (hasLicense) {
                        this.lastLicenseData.source = newSourceLocation;
                        this.lastLicenseData.content = comment;
                    }
                }
            }
        }

        @Override
        public void leave(CssNode node) {
        }

        private String fileNameForSourceCodeLocation(SourceCodeLocation location) {
            if (location == null || location.getSourceCode() == null) {
                return null;
            }
            return location.getSourceCode().getFileName();
        }
    }

    private static class LastLicenseData {
        private String source;
        private String content;

        private LastLicenseData() {
        }
    }
}

