/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CollectMixinDefinitions
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String DUPLICATE_MIXIN_DEFINITION_NAME_ERROR_MESSAGE = "A mixin definition name occured more than once";
    @VisibleForTesting
    static final String DUPLICATE_ARGUMENT_NAME_ERROR_MESSAGE = "The mixin definition has arguments with the same name";
    @VisibleForTesting
    static final String INVALID_ARGUMENT_ERROR_MESSAGE = "The mixin definition has invalid arguments";
    @VisibleForTesting
    static final String INVALID_BLOCK_ERROR_MESSAGE = "The mixin definition is not placed on the top level";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Map<String, CssMixinDefinitionNode> definitions;

    public CollectMixinDefinitions(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.definitions = new HashMap<String, CssMixinDefinitionNode>();
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        if (!node.getParent().getParent().getClass().equals(CssRootNode.class)) {
            this.errorManager.report(new GssError(INVALID_BLOCK_ERROR_MESSAGE, node.getSourceCodeLocation()));
            return false;
        }
        if (this.definitions.containsKey(node.getDefinitionName())) {
            this.errorManager.report(new GssError(DUPLICATE_MIXIN_DEFINITION_NAME_ERROR_MESSAGE, node.getSourceCodeLocation()));
            return false;
        }
        if (!this.checkArguments(node)) {
            return false;
        }
        this.definitions.put(node.getDefinitionName(), node);
        return true;
    }

    @Override
    public void leaveMixinDefinition(CssMixinDefinitionNode node) {
        this.visitController.removeCurrentNode();
    }

    private boolean checkArguments(CssMixinDefinitionNode node) {
        HashSet arguments = Sets.newHashSetWithExpectedSize((int)node.getArguments().numChildren());
        for (CssValueNode arg : node.getArguments().getChildren()) {
            boolean isSeparator = ",".equals(arg.getValue());
            if (!isSeparator && !CssConstantReferenceNode.isDefinitionReference(arg.getValue())) {
                this.errorManager.report(new GssError(INVALID_ARGUMENT_ERROR_MESSAGE, node.getSourceCodeLocation()));
                return false;
            }
            if (arguments.contains(arg.getValue())) {
                this.errorManager.report(new GssError(DUPLICATE_ARGUMENT_NAME_ERROR_MESSAGE, node.getSourceCodeLocation()));
                return false;
            }
            if (isSeparator) continue;
            arguments.add(arg.getValue());
        }
        return true;
    }

    public Map<String, CssMixinDefinitionNode> getDefinitions() {
        return this.definitions;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

