/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.common.css.compiler.ast.CssProvideNode;
import com.google.common.css.compiler.ast.CssRequireNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import java.util.Map;

public final class CollectProvideNamespaces
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final VisitController visitController;
    private final Map<String, String> filenameProvideMap = Maps.newHashMap();
    private final ListMultimap<String, String> filenameRequireMap = LinkedListMultimap.create();
    private final ListMultimap<String, String> defProvideMap = LinkedListMultimap.create();
    private final ListMultimap<String, String> defmixinProvideMap = LinkedListMultimap.create();

    public Map<String, String> getFilenameProvideMap() {
        return this.filenameProvideMap;
    }

    public ListMultimap<String, String> getFilenameRequireMap() {
        return this.filenameRequireMap;
    }

    public ListMultimap<String, String> getDefProvideMap() {
        return this.defProvideMap;
    }

    public ListMultimap<String, String> getDefmixinProvideMap() {
        return this.defmixinProvideMap;
    }

    public CollectProvideNamespaces(VisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public boolean enterProvideNode(CssProvideNode node) {
        Preconditions.checkState((node.getSourceCodeLocation() != null ? 1 : 0) != 0);
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        this.filenameProvideMap.put(filename, node.getProvide());
        return true;
    }

    @Override
    public boolean enterRequireNode(CssRequireNode node) {
        Preconditions.checkState((node.getSourceCodeLocation() != null ? 1 : 0) != 0);
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        this.filenameRequireMap.put((Object)filename, (Object)node.getRequire());
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        if (node.getSourceCodeLocation() == null) {
            return true;
        }
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        String provideNamespace = this.filenameProvideMap.get(filename);
        this.defProvideMap.put((Object)node.getName().getValue(), (Object)provideNamespace);
        return true;
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        if (node.getSourceCodeLocation() == null) {
            return true;
        }
        String filename = node.getSourceCodeLocation().getSourceCode().getFileName();
        String provideNamespace = this.filenameProvideMap.get(filename);
        Preconditions.checkArgument((provideNamespace != null ? 1 : 0) != 0);
        this.defmixinProvideMap.put((Object)node.getDefinitionName(), (Object)provideNamespace);
        return true;
    }

    @Override
    public void runPass() {
        this.filenameProvideMap.clear();
        this.filenameRequireMap.clear();
        this.defProvideMap.clear();
        this.defmixinProvideMap.clear();
        this.visitController.startVisit(this);
    }
}

