/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.common.css.compiler.ast.CssCharSetNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssIdSelectorNode;
import com.google.common.css.compiler.ast.CssImportRuleNode;
import com.google.common.css.compiler.ast.CssKeyListNode;
import com.google.common.css.compiler.ast.CssKeyNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNodesListNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssPageRuleNode;
import com.google.common.css.compiler.ast.CssPageSelectorNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import java.util.List;
import java.util.logging.Logger;

public class CompactPrintingVisitor
extends DefaultTreeVisitor {
    private static final Logger logger = Logger.getLogger(CompactPrintingVisitor.class.getName());
    protected final VisitController visitController;
    protected final CodeBuffer buffer;
    private static final String COMPACTED_PRINTED_STRING = null;
    private static final ImmutableSet<String> ARGUMENT_SEPARATORS = ImmutableSet.of((Object)",", (Object)"=", (Object)" ");

    public CompactPrintingVisitor(VisitController visitController, CodeBuffer buffer) {
        this.visitController = (VisitController)Preconditions.checkNotNull((Object)visitController);
        this.buffer = (CodeBuffer)Preconditions.checkNotNull((Object)buffer);
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        return false;
    }

    @Override
    public boolean enterImportRule(CssImportRuleNode node) {
        this.buffer.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            if (param instanceof CssStringNode) {
                this.buffer.append(param.toString());
                continue;
            }
            this.buffer.append(param.getValue());
        }
        return true;
    }

    @Override
    public void leaveImportRule(CssImportRuleNode node) {
        this.buffer.append(';');
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode node) {
        this.buffer.append(node.getType().toString());
        if (!node.getParameters().isEmpty()) {
            this.buffer.append(' ');
        }
        return true;
    }

    private void appendMediaParameterWithParentheses(CssValueNode node) {
        this.buffer.append('(');
        this.buffer.append(node.getValue());
        this.buffer.append(')');
    }

    @Override
    public void leaveMediaRule(CssMediaRuleNode node) {
        this.buffer.append('}');
    }

    @Override
    public boolean enterPageRule(CssPageRuleNode node) {
        this.buffer.append(node.getType().toString());
        this.buffer.append(' ');
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(param.getValue());
        }
        this.buffer.deleteLastCharIfCharIs(' ');
        return true;
    }

    @Override
    public boolean enterPageSelector(CssPageSelectorNode node) {
        this.buffer.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            this.buffer.append(param.getValue());
        }
        return true;
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode node) {
        this.buffer.append(node.getType().toString());
        return true;
    }

    @Override
    public boolean enterCharSet(CssCharSetNode node) {
        this.buffer.append(node.getType().toString());
        List<CssValueNode> parameters = node.getParameters();
        if (!parameters.isEmpty()) {
            this.buffer.append(parameters.get(0));
        }
        return true;
    }

    @Override
    public void leaveCharSet(CssCharSetNode node) {
        this.buffer.append(';');
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        String name = selector.getSelectorName();
        if (name != null) {
            this.buffer.append(name);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        this.buffer.append(',');
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getRefinerName());
        if (node.getFunctionType() == CssPseudoClassNode.FunctionType.NTH) {
            this.buffer.append(node.getArgument().replace(" ", ""));
            this.buffer.append(')');
        } else if (node.getFunctionType() == CssPseudoClassNode.FunctionType.LANG) {
            this.buffer.append(node.getArgument());
            this.buffer.append(')');
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (node.getFunctionType() == CssPseudoClassNode.FunctionType.NOT) {
            this.buffer.deleteLastCharIfCharIs(',');
            this.buffer.append(')');
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getAttributeName());
        this.buffer.append(node.getMatchSymbol());
        this.buffer.append(node.getValue());
        this.buffer.append(node.getSuffix());
        return true;
    }

    private void appendRefiner(CssRefinerNode node) {
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getRefinerName());
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (combinator != null) {
            this.buffer.append(combinator.getCombinatorType().getCanonicalName());
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        this.buffer.deleteLastCharIfCharIs(',');
    }

    @Override
    public void leaveSelectorBlock(CssSelectorListNode node) {
        this.buffer.deleteLastCharIfCharIs(',');
    }

    @Override
    public boolean enterDeclarationBlock(CssDeclarationBlockNode block) {
        this.buffer.append('{');
        return true;
    }

    @Override
    public void leaveDeclarationBlock(CssDeclarationBlockNode block) {
        this.buffer.deleteLastCharIfCharIs(';');
        this.buffer.append('}');
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        if (block.getParent() instanceof CssUnknownAtRuleNode || block.getParent() instanceof CssMediaRuleNode) {
            this.buffer.append('{');
        }
        return true;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        if (declaration.hasStarHack()) {
            this.buffer.append('*');
        }
        this.buffer.append(declaration.getPropertyName().getValue());
        this.buffer.append(':');
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode declaration) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(';');
    }

    @Override
    public boolean enterCompositeValueNode(CssCompositeValueNode node) {
        if (node.hasParenthesis()) {
            this.buffer.append('(');
        }
        return true;
    }

    @Override
    public void leaveCompositeValueNode(CssCompositeValueNode node) {
        this.buffer.deleteLastCharIfCharIs(' ');
        if (node.getParent() instanceof CssPropertyValueNode) {
            this.buffer.append(' ');
        }
        if (node.hasParenthesis()) {
            this.buffer.append(')');
        }
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssPriorityNode) {
            this.buffer.deleteLastCharIfCharIs(' ');
        }
        this.appendValueNode(node);
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (node.getParent() instanceof CssPropertyValueNode) {
            this.buffer.append(' ');
        }
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(parent.getOperator().getOperatorName());
        return true;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        this.buffer.append(node.getFunctionName());
        this.buffer.append('(');
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        if (ARGUMENT_SEPARATORS.contains((Object)node.toString())) {
            this.buffer.deleteLastCharIfCharIs(' ');
        }
        this.appendValueNode(node);
        return true;
    }

    @Override
    public boolean enterConditionalBlock(CssConditionalBlockNode node) {
        this.visitController.stopVisit();
        logger.warning("Conditional block should not be present: " + node.toString() + (String)(node.getSourceCodeLocation() != null ? "@" + node.getSourceCodeLocation().getLineNumber() : ""));
        return true;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        this.buffer.append('@').append(node.getName().toString());
        if (!node.getParameters().isEmpty()) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        this.buffer.append(' ');
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getType().hasBlock()) {
            if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
                this.buffer.append('}');
            }
        } else {
            this.buffer.append(';');
        }
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode node) {
        this.buffer.append('@').append(node.getName().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            this.buffer.append(param.getValue());
        }
        if (node.getType().hasBlock()) {
            this.buffer.append('{');
        }
        return true;
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode node) {
        if (node.getType().hasBlock()) {
            this.buffer.append('}');
        } else {
            this.buffer.append(';');
        }
    }

    @Override
    public boolean enterKey(CssKeyNode node) {
        String value = node.getKeyValue();
        if (value != null) {
            this.buffer.append(value);
        }
        return true;
    }

    @Override
    public void leaveKey(CssKeyNode key) {
        this.buffer.append(',');
    }

    @Override
    public void leaveKeyBlock(CssKeyListNode block) {
        this.buffer.deleteLastCharIfCharIs(',');
    }

    public String getCompactPrintedString() {
        return COMPACTED_PRINTED_STRING;
    }

    protected void appendValueNode(CssValueNode node) {
        if (node instanceof CssCompositeValueNode) {
            return;
        }
        if (node instanceof CssBooleanExpressionNode && node.getParent() instanceof CssMediaRuleNode) {
            this.appendMediaParameterWithParentheses(node);
            return;
        }
        if (node instanceof CssStringNode) {
            CssStringNode s = (CssStringNode)node;
            this.buffer.append(s.toString(CssStringNode.HTML_ESCAPER));
            return;
        }
        if (node instanceof CssNumericNode) {
            CssNumericNode n = (CssNumericNode)node;
            this.buffer.append(n.getNumericPart());
            this.buffer.append(n.getUnit());
            return;
        }
        this.buffer.append(node.toString());
    }
}

