/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import java.util.List;
import java.util.Map;

public class ConstantDefinitions {
    private final Map<String, CssDefinitionNode> constants = Maps.newHashMap();
    private final ListMultimap<String, CssDefinitionNode> constantsMultimap = LinkedListMultimap.create();

    Map<String, CssDefinitionNode> getConstants() {
        return this.constants;
    }

    public Multimap<String, CssDefinitionNode> getConstantMultimap() {
        return this.constantsMultimap;
    }

    public CssDefinitionNode getConstantDefinition(String constant) {
        return this.constants.get(constant);
    }

    public List<CssDefinitionNode> getConstantDefinitions(String constant) {
        return this.constantsMultimap.get((Object)constant);
    }

    public void addConstantDefinition(CssDefinitionNode definition) {
        this.constants.put(definition.getName().getValue(), definition);
        this.constantsMultimap.put((Object)definition.getName().getValue(), (Object)definition);
    }

    public Iterable<String> getConstantsNames() {
        return this.constants.keySet();
    }
}

