/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.Lists;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssAbstractBlockNode;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;

public class CreateConditionalNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Deque<CssConditionalBlockNode> stack = new ConcurrentLinkedDeque<CssConditionalBlockNode>();
    private CssConditionalBlockNode activeBlockNode = null;
    private static final String IF_NAME = CssAtRuleNode.Type.IF.getCanonicalName();
    private static final String ELSEIF_NAME = CssAtRuleNode.Type.ELSEIF.getCanonicalName();
    private static final String ELSE_NAME = CssAtRuleNode.Type.ELSE.getCanonicalName();

    public CreateConditionalNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        String name = node.getName().getValue();
        if (name.equals(IF_NAME)) {
            CssConditionalBlockNode condBlock = new CssConditionalBlockNode(node.getComments());
            condBlock.setSourceCodeLocation(node.getSourceCodeLocation());
            this.stack.push(condBlock);
        } else if (name.equals(ELSEIF_NAME) || name.equals(ELSE_NAME)) {
            if (this.activeBlockNode == null) {
                this.errorManager.report(new GssError("@" + name + " without previous @" + IF_NAME, node.getSourceCodeLocation()));
                this.visitController.removeCurrentNode();
                return false;
            }
            this.stack.push(this.activeBlockNode);
        }
        this.activeBlockNode = null;
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        String name = node.getName().getValue();
        if (name.equals(IF_NAME) || name.equals(ELSEIF_NAME) || name.equals(ELSE_NAME)) {
            this.activeBlockNode = this.stack.pop();
            CssConditionalRuleNode conditionalNode = this.createConditionalRuleNode(node, name);
            this.activeBlockNode.addChildToBack(conditionalNode);
            this.updateLocation(this.activeBlockNode);
            if (name.equals(IF_NAME)) {
                this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{this.activeBlockNode}), false);
            } else {
                this.visitController.removeCurrentNode();
                if (name.equals(ELSE_NAME)) {
                    this.activeBlockNode = null;
                }
            }
        }
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        this.activeBlockNode = null;
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        this.activeBlockNode = null;
        return true;
    }

    private CssConditionalRuleNode createConditionalRuleNode(CssUnknownAtRuleNode node, String name) {
        CssAbstractBlockNode block = node.getBlock();
        if (block == null) {
            this.errorManager.report(new GssError("@" + name + " without block", node.getSourceCodeLocation()));
        }
        List<CssValueNode> params = node.getParameters();
        CssBooleanExpressionNode condition = null;
        if (!name.equals(ELSE_NAME)) {
            if (!params.isEmpty()) {
                CssValueNode param;
                if (params.size() > 1) {
                    this.errorManager.report(new GssError("@" + name + " with too many parameters", node.getSourceCodeLocation()));
                }
                condition = (param = params.get(0)) instanceof CssBooleanExpressionNode ? (CssBooleanExpressionNode)param : new CssBooleanExpressionNode(CssBooleanExpressionNode.Type.CONSTANT, param.getValue(), param.getSourceCodeLocation());
            } else {
                this.errorManager.report(new GssError("@" + name + " without condition", node.getSourceCodeLocation()));
            }
        } else if (!params.isEmpty()) {
            this.errorManager.report(new GssError("@" + ELSE_NAME + " with too many parameters", node.getSourceCodeLocation()));
        }
        CssConditionalRuleNode rulenode = new CssConditionalRuleNode(CssAtRuleNode.Type.valueOf(name.toUpperCase()), node.getName(), condition, block);
        rulenode.setComments(node.getComments());
        rulenode.setSourceCodeLocation(node.getSourceCodeLocation());
        return rulenode;
    }

    private void updateLocation(CssConditionalBlockNode blockNode) {
        SourceCodeLocation firstLocation = blockNode.getSourceCodeLocation();
        SourceCodeLocation lastLocation = ((CssConditionalRuleNode)blockNode.getLastChild()).getSourceCodeLocation();
        SourceCodeLocation mergedLocation = new SourceCodeLocation(firstLocation.getSourceCode(), firstLocation.getBeginCharacterIndex(), firstLocation.getBeginLineNumber(), firstLocation.getBeginIndexInLine(), lastLocation.getEndCharacterIndex(), lastLocation.getEndLineNumber(), lastLocation.getEndIndexInLine());
        blockNode.setSourceCodeLocation(mergedLocation);
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

