/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.List;

public class CreateDefinitionNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String DEF_NAME = CssAtRuleNode.Type.DEF.getCanonicalName();
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;

    public CreateDefinitionNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getName().getValue().equals(DEF_NAME)) {
            if (node.getType().hasBlock()) {
                this.reportError("@" + DEF_NAME + " with block", node);
                return false;
            }
            List<CssValueNode> params = node.getParameters();
            if (params.isEmpty()) {
                this.reportError("@" + DEF_NAME + " without name", node);
                return false;
            }
            CssNode nameNode = params.get(0);
            if (!(nameNode instanceof CssLiteralNode)) {
                this.reportError("@" + DEF_NAME + " without a valid literal as name", node);
                return false;
            }
            CssLiteralNode defNameNode = (CssLiteralNode)nameNode;
            String defName = defNameNode.getValue();
            if (!CssConstantReferenceNode.isDefinitionReference(defName)) {
                this.errorManager.reportWarning(new GssError(String.format("WARNING for invalid @def name %s. We will ignore this.", defName), defNameNode.getSourceCodeLocation()));
            }
            CssDefinitionNode def = new CssDefinitionNode(params.subList(1, params.size()), (CssLiteralNode)nameNode, node.getComments(), node.getSourceCodeLocation());
            this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{def}), false);
            return false;
        }
        return true;
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

