/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssForLoopRuleNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssLoopVariableNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Pattern;

public class CreateForLoopNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String SYNTAX_ERROR = "Invalid syntax for @for rule. Expected: @for <IDENTIFIER> from <CONST|NUMBER> to <CONST|NUMBER>) [step <CONST|NUMBER>]";
    @VisibleForTesting
    static final String ILLEGAL_VARIABLE_NAME = "Illegal variable name.";
    @VisibleForTesting
    static final String OVERRIDE_VARIABLE_NAME = "Overriding existing variable name.";
    private static final String FOR_NAME = CssAtRuleNode.Type.FOR.getCanonicalName();
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$[a-zA-Z_]\\w*");
    private static final String FROM_KEYWORD = "from";
    private static final String TO_KEYWORD = "to";
    private static final String STEP_KEYWORD = "step";
    private static final int VARIABLE_INDEX = 0;
    private static final int FROM_KEYWORD_INDEX = 1;
    private static final int FROM_VALUE_INDEX = 2;
    private static final int TO_KEYOWRD_INDEX = 3;
    private static final int TO_VALUE_INDEX = 4;
    private static final int STEP_KEYOWRD_INDEX = 5;
    private static final int STEP_VALUE_INDEX = 6;
    private static final int ARGUMENT_COUNT_WITHOUT_STEP = 5;
    private static final int ARGUMENT_COUNT_WITH_STEP = 7;
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Deque<String> variables = new ConcurrentLinkedDeque<String>();
    private int uniqueLoopId = 0;

    public CreateForLoopNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        if (!node.getName().getValue().equals(FOR_NAME)) {
            return true;
        }
        if (!node.getType().hasBlock()) {
            this.reportError("@" + FOR_NAME + " with no block", node);
            return false;
        }
        if (node.getChildren().size() != 5 && node.getChildren().size() != 7) {
            this.reportError(SYNTAX_ERROR, node);
            return false;
        }
        if (!(node.getChildAt(0) instanceof CssLoopVariableNode && node.getChildAt(1) instanceof CssLiteralNode && FROM_KEYWORD.equals(((CssValueNode)node.getChildAt(1)).getValue()) && this.isValidValueNode((CssValueNode)node.getChildAt(2)) && node.getChildAt(3) instanceof CssLiteralNode && TO_KEYWORD.equals(((CssValueNode)node.getChildAt(3)).getValue()) && this.isValidValueNode((CssValueNode)node.getChildAt(4)))) {
            this.reportError(SYNTAX_ERROR, node);
            return false;
        }
        String variableName = ((CssValueNode)node.getChildAt(0)).getValue();
        if (!VARIABLE_PATTERN.matcher(variableName).matches()) {
            this.reportError(ILLEGAL_VARIABLE_NAME, (CssNode)node.getChildAt(0));
            return false;
        }
        if (this.variables.contains(variableName)) {
            this.reportError(OVERRIDE_VARIABLE_NAME, (CssNode)node.getChildAt(0));
            return false;
        }
        CssValueNode from = (CssValueNode)node.getChildAt(2);
        CssValueNode to = (CssValueNode)node.getChildAt(4);
        CssValueNode step = new CssNumericNode("1", "");
        if (node.getChildren().size() == 7) {
            if (!(node.getChildAt(5) instanceof CssLiteralNode && STEP_KEYWORD.equals(((CssValueNode)node.getChildAt(5)).getValue()) && this.isValidValueNode((CssValueNode)node.getChildAt(6)))) {
                this.reportError(SYNTAX_ERROR, node);
                return false;
            }
            step = (CssValueNode)node.getChildAt(6);
        }
        CssForLoopRuleNode loopNode = new CssForLoopRuleNode(node.getName(), node.getBlock(), node.getComments(), from, to, step, variableName, this.nextLoopId(), node.getSourceCodeLocation());
        loopNode.setParameters(node.getChildren());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssForLoopRuleNode[]{loopNode}), true);
        this.variables.push(variableName);
        return true;
    }

    @Override
    public void leaveForLoop(CssForLoopRuleNode node) {
        this.variables.pop();
    }

    private boolean isValidValueNode(CssValueNode node) {
        return node instanceof CssNumericNode || node instanceof CssLiteralNode;
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    private int nextLoopId() {
        return this.uniqueLoopId++;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

