/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.css.JobDescription;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.passes.GssSourceMapGenerator;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public final class DefaultGssSourceMapGenerator
implements GssSourceMapGenerator {
    private final SourceMapGenerator generator;
    private static final ImmutableMap<JobDescription.SourceMapDetailLevel, Predicate<CssNode>> DETAIL_LEVEL_PREDICATES = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)((Object)JobDescription.SourceMapDetailLevel.ALL), (Object)Predicates.alwaysTrue(), (Object)((Object)JobDescription.SourceMapDetailLevel.DEFAULT), (Object)Predicates.alwaysTrue()));
    private final Deque<Mapping> mappings;
    private final List<Mapping> allMappings;
    private final JobDescription.SourceMapDetailLevel sourceMapDetailLevel;
    private final Predicate<CssNode> detailLevelPredicate;

    public DefaultGssSourceMapGenerator(JobDescription.SourceMapDetailLevel sourceMapDetailLevel) {
        Preconditions.checkState((sourceMapDetailLevel != null ? 1 : 0) != 0);
        this.mappings = new ArrayDeque<Mapping>();
        this.generator = SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3);
        this.allMappings = new ArrayList<Mapping>();
        this.sourceMapDetailLevel = sourceMapDetailLevel;
        this.detailLevelPredicate = (Predicate)DETAIL_LEVEL_PREDICATES.get((Object)this.sourceMapDetailLevel);
    }

    @Override
    public void appendOutputTo(Appendable out, String name) throws IOException {
        this.generateSourceMap();
        this.generator.appendTo(out, name);
    }

    @Override
    public void startSourceMapping(CssNode node, int startLine, int startCharIndex) {
        Preconditions.checkState((node != null ? 1 : 0) != 0);
        Preconditions.checkState((startLine >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((startCharIndex >= 0 ? 1 : 0) != 0);
        if (node.getSourceCodeLocation() != null && this.detailLevelPredicate.apply((Object)node)) {
            Mapping mapping = new Mapping();
            mapping.node = node;
            mapping.start = new FilePosition(startLine, startCharIndex);
            this.mappings.push(mapping);
            this.allMappings.add(mapping);
        }
    }

    @Override
    public void endSourceMapping(CssNode node, int endLine, int endCharIndex) {
        Preconditions.checkState((node != null ? 1 : 0) != 0);
        Preconditions.checkState((endLine >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((endCharIndex >= -1 ? 1 : 0) != 0);
        ++endCharIndex;
        if (!this.mappings.isEmpty() && this.mappings.peek().node == node) {
            Mapping mapping = this.mappings.pop();
            mapping.end = new FilePosition(endLine, endCharIndex);
        }
    }

    @Override
    public void setSourceRoot(String path) {
        ((SourceMapGeneratorV3)this.generator).setSourceRoot(path);
    }

    private void generateSourceMap() {
        ArrayList<CompleteMapping> completeMappings = new ArrayList<CompleteMapping>(this.allMappings.size());
        for (Mapping mapping : this.allMappings) {
            if (mapping.node.getSourceCodeLocation().isUnknown()) continue;
            CompleteMapping completeMapping = new CompleteMapping(mapping);
            if (completeMapping.sourceFile == null) continue;
            completeMappings.add(completeMapping);
        }
        Collections.sort(completeMappings);
        for (CompleteMapping completeMapping : completeMappings) {
            this.generator.addMapping(completeMapping.sourceFile, null, completeMapping.inputStart, completeMapping.outputStart, completeMapping.outputEnd);
        }
    }

    static class Mapping {
        CssNode node;
        FilePosition start;
        FilePosition end;

        Mapping() {
        }
    }

    private static final class CompleteMapping
    implements Comparable<CompleteMapping> {
        final String sourceFile;
        final FilePosition inputStart;
        final FilePosition outputStart;
        final FilePosition outputEnd;

        CompleteMapping(Mapping mapping) {
            CssNode node = mapping.node;
            this.sourceFile = CompleteMapping.getSourceFileName(node);
            this.inputStart = new FilePosition(CompleteMapping.getStartLineno(node), CompleteMapping.getStartCharIndex(node));
            this.outputStart = mapping.start;
            this.outputEnd = mapping.end;
        }

        @Override
        public int compareTo(CompleteMapping m) {
            int delta = this.outputStart.getLine() - m.outputStart.getLine();
            if (delta == 0) {
                delta = this.outputStart.getColumn() - m.outputStart.getColumn();
            }
            return delta;
        }

        private static String getSourceFileName(CssNode node) {
            return node.getSourceCodeLocation().getSourceCode().getFileName();
        }

        private static int getStartLineno(CssNode node) {
            return node.getSourceCodeLocation().getLineNumber() - 1;
        }

        private static int getStartCharIndex(CssNode node) {
            return node.getSourceCodeLocation().getCharacterIndex();
        }
    }
}

