/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.passes.CodeBuffer;

public class DefinitionPrintingVisitor<T>
extends DefaultTreeVisitor {
    private final CodeBuffer buffer;
    private final T chunk;
    private boolean printDefinition;

    public DefinitionPrintingVisitor(T chunk, CodeBuffer buffer) {
        this.chunk = chunk;
        this.buffer = buffer;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode definition) {
        this.printDefinition = this.chunk.equals(definition.getChunk());
        if (this.printDefinition) {
            this.buffer.append("@def ").append(definition.getName()).append(' ');
        }
        return this.printDefinition;
    }

    @Override
    public void leaveDefinition(CssDefinitionNode node) {
        if (this.printDefinition) {
            this.buffer.append(";").startNewLine();
            this.printDefinition = false;
        }
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (!this.printDefinition) {
            return false;
        }
        if (node instanceof CssPriorityNode) {
            this.buffer.deleteLastChar();
        }
        this.buffer.append(node);
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode node) {
        if (!this.printDefinition) {
            return;
        }
        this.buffer.append(' ');
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        if (!this.printDefinition) {
            return false;
        }
        this.buffer.append(node.getFunctionName());
        this.buffer.append('(');
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        if (!this.printDefinition) {
            return;
        }
        this.buffer.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        if (!this.printDefinition) {
            return false;
        }
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(node);
        return true;
    }
}

