/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.MarkRemovableRulesetNodes;
import com.google.common.css.compiler.passes.PassUtil;
import java.util.Set;

public class DisallowDuplicateDeclarations
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String ERROR_STR = "Detected multiple identical, non-alternate declarations in the same ruleset. If this is intentional please use the /* @alternate */ annotation. ";
    private final VisitController visitController;
    private final ErrorManager errorManager;
    private final Set<String> propertyNames = Sets.newHashSet();

    public DisallowDuplicateDeclarations(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        for (CssNode child : node.getDeclarations().childIterable()) {
            SourceCodeLocation location = node.getSourceCodeLocation();
            if (location == null && !node.getSelectors().isEmpty()) {
                location = ((CssSelectorNode)node.getSelectors().getChildAt(0)).getSourceCodeLocation();
            }
            this.processDeclaration((CssDeclarationNode)child, location);
        }
        this.propertyNames.clear();
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    @VisibleForTesting
    void processDeclaration(CssDeclarationNode declaration, SourceCodeLocation location) {
        Object propertyName = declaration.getPropertyName().getPropertyName();
        if (MarkRemovableRulesetNodes.PROPERTIES_NOT_TO_BE_CHECKED.contains(propertyName)) {
            return;
        }
        if (declaration.hasStarHack()) {
            propertyName = "*" + (String)propertyName;
        }
        if (PassUtil.hasAlternateAnnotation(declaration)) {
            return;
        }
        if (this.propertyNames.contains(propertyName)) {
            this.errorManager.report(new GssError(ERROR_STR + declaration, location));
        } else {
            this.propertyNames.add((String)propertyName);
        }
    }
}

