/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.Ordering;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.SourceCodeLocationBuilder;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.passes.UniformVisitor;

public class LocationBoundingVisitor
implements UniformVisitor {
    private SourceCodeLocation result = null;

    @Override
    public void enter(CssNode n) {
        SourceCodeLocation loc = n.getSourceCodeLocation();
        if (loc == null || loc.isUnknown()) {
            return;
        }
        if (this.result == null || this.result.isUnknown()) {
            this.result = loc;
        } else {
            Ordering o = Ordering.natural();
            SourceCodeLocation.SourceCodePoint lowerBound = (SourceCodeLocation.SourceCodePoint)o.min((Object)this.result.getBegin(), (Object)loc.getBegin());
            SourceCodeLocation.SourceCodePoint upperBound = (SourceCodeLocation.SourceCodePoint)o.max((Object)this.result.getEnd(), (Object)loc.getEnd());
            this.result = new SourceCodeLocationBuilder().setSourceCode(this.result.getSourceCode()).setBeginLocation(lowerBound).setEndLocation(upperBound).getSourceCodeLocation();
        }
    }

    @Override
    public void leave(CssNode node) {
    }

    public static SourceCodeLocation bound(CssNode n) {
        SourceCodeLocation location = n.getSourceCodeLocation();
        if (location != null && !location.isUnknown()) {
            return location;
        }
        LocationBoundingVisitor v = new LocationBoundingVisitor();
        n.getVisitController().startVisit(UniformVisitor.Adapters.asVisitor(v));
        if (v.result == null) {
            return SourceCodeLocation.getUnknownLocation();
        }
        return v.result;
    }
}

