/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.ast.SkippingTreeVisitor;
import com.google.common.css.compiler.passes.PassUtil;
import java.util.Iterator;

public class MergeAdjacentRulesetNodesWithSameSelector
extends SkippingTreeVisitor
implements CssCompilerPass {
    private final CssTree tree;
    private final MutatingVisitController visitController;

    public MergeAdjacentRulesetNodesWithSameSelector(CssTree tree) {
        this(tree, false);
    }

    public MergeAdjacentRulesetNodesWithSameSelector(CssTree tree, boolean skipping) {
        super(skipping);
        this.tree = tree;
        this.visitController = tree.getMutatingVisitController();
    }

    @Override
    public boolean enterTree(CssRootNode root) {
        this.tree.resetRulesetNodesToRemove();
        return true;
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        if (block.numChildren() <= 1) {
            return true;
        }
        Iterator<CssNode> iterator = block.getChildIterator();
        CssNode node = (CssNode)iterator.next();
        if ((node = this.skipNonRulesetNode(node, iterator)) == null) {
            return true;
        }
        CssRulesetNode ruleToMergeTo = (CssRulesetNode)node;
        while (iterator.hasNext()) {
            node = iterator.next();
            if (!(node instanceof CssRulesetNode)) {
                if ((node = this.skipNonRulesetNode(node, iterator)) == null) {
                    return true;
                }
                ruleToMergeTo = (CssRulesetNode)node;
                continue;
            }
            CssRulesetNode currentRule = (CssRulesetNode)node;
            if (!this.canModifyRuleset(currentRule)) continue;
            if (this.sameSelectors(ruleToMergeTo.getSelectors(), currentRule.getSelectors())) {
                for (CssNode decl : currentRule.getDeclarations().childIterable()) {
                    ruleToMergeTo.addDeclaration(decl);
                }
                this.tree.getRulesetNodesToRemove().addRulesetNode(currentRule);
                continue;
            }
            ruleToMergeTo = currentRule;
        }
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private boolean sameSelectors(CssSelectorListNode s1, CssSelectorListNode s2) {
        if (!PassUtil.printSelectorList(s1).equals(PassUtil.printSelectorList(s2))) {
            return false;
        }
        int n = s1.numChildren();
        Preconditions.checkArgument((n == s2.numChildren() ? 1 : 0) != 0);
        for (int i = 0; i < n; ++i) {
            Object m2;
            Object m1 = ((CssSelectorNode)s1.getChildAt(i)).getChunk();
            if (m1 == null != ((m2 = ((CssSelectorNode)s2.getChildAt(i)).getChunk()) == null)) {
                throw new IllegalStateException();
            }
            if (m1 == null || m1.equals(m2)) continue;
            return false;
        }
        return true;
    }

    private CssNode skipNonRulesetNode(CssNode node, Iterator<CssNode> iterator) {
        while (!(node instanceof CssRulesetNode)) {
            if (iterator.hasNext()) {
                node = iterator.next();
                continue;
            }
            return null;
        }
        return node;
    }
}

