/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.CodePrinter;
import com.google.common.css.compiler.passes.GssSourceMapGenerator;
import com.google.common.css.compiler.passes.PrettyPrintingVisitor;
import javax.annotation.Nullable;

public class PrettyPrinter
extends CodePrinter
implements CssCompilerPass {
    private String prettyPrintedString = null;
    private boolean stripQuotes = false;
    private boolean preserveComments = false;

    public PrettyPrinter(VisitController visitController, @Nullable CodeBuffer buffer, @Nullable GssSourceMapGenerator generator) {
        super(visitController, buffer, generator);
    }

    public PrettyPrinter(VisitController visitController, GssSourceMapGenerator generator) {
        this(visitController, null, generator);
    }

    public PrettyPrinter(VisitController visitController) {
        this(visitController, null, null);
    }

    public void setStripQuotes(boolean stripQuotes) {
        this.stripQuotes = stripQuotes;
    }

    public PrettyPrinter setPreserveComments(boolean preserve) {
        this.preserveComments = preserve;
        return this;
    }

    public String getPrettyPrintedString() {
        return this.prettyPrintedString;
    }

    @Override
    protected CssTreeVisitor createVisitor(VisitController visitController, CodeBuffer codeBuffer) {
        return new PrettyPrintingVisitor(codeBuffer, this.stripQuotes, this.preserveComments);
    }

    @Override
    public void runPass() {
        this.resetBuffer();
        this.visit();
        this.prettyPrintedString = this.getOutputBuffer();
    }
}

