/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.css.IdentitySubstitutionMap;
import com.google.common.css.MultipleMappingSubstitutionMap;
import com.google.common.css.SubstitutionMap;
import java.util.Map;

public class RecordingSubstitutionMap
implements SubstitutionMap.Initializable {
    private final SubstitutionMap delegate;
    private final Predicate<? super String> shouldRecordMappingForCodeGeneration;
    private final Map<String, String> mappings = Maps.newLinkedHashMap();

    private RecordingSubstitutionMap(SubstitutionMap map, Predicate<? super String> shouldRecordMappingForCodeGeneration) {
        this.delegate = map;
        this.shouldRecordMappingForCodeGeneration = shouldRecordMappingForCodeGeneration;
    }

    @Override
    public String get(String key) {
        Preconditions.checkNotNull((Object)key);
        if (!this.shouldRecordMappingForCodeGeneration.apply((Object)key)) {
            return key;
        }
        if (this.delegate instanceof MultipleMappingSubstitutionMap) {
            MultipleMappingSubstitutionMap.ValueWithMappings valueWithMappings = ((MultipleMappingSubstitutionMap)this.delegate).getValueWithMappings(key);
            this.mappings.putAll(valueWithMappings.mappings);
            return valueWithMappings.value;
        }
        return this.mappings.computeIfAbsent(key, this.delegate::get);
    }

    public Map<String, String> getMappings() {
        return ImmutableMap.copyOf(this.mappings);
    }

    @Override
    public void initializeWithMappings(Map<String, String> newMappings) {
        Preconditions.checkState((boolean)this.mappings.isEmpty());
        if (!newMappings.isEmpty()) {
            this.mappings.putAll(newMappings);
            ((SubstitutionMap.Initializable)this.delegate).initializeWithMappings(newMappings);
        }
    }

    public static final class Builder {
        private SubstitutionMap delegate = new IdentitySubstitutionMap();
        private Predicate<? super String> shouldRecordMappingForCodeGeneration = Predicates.alwaysTrue();
        private final Map<String, String> mappings = Maps.newLinkedHashMap();

        public Builder withSubstitutionMap(SubstitutionMap d) {
            this.delegate = (SubstitutionMap)Preconditions.checkNotNull((Object)d);
            return this;
        }

        public Builder shouldRecordMappingForCodeGeneration(Predicate<? super String> p) {
            this.shouldRecordMappingForCodeGeneration = Predicates.and(this.shouldRecordMappingForCodeGeneration, p);
            return this;
        }

        public Builder withMappings(Map<? extends String, ? extends String> m) {
            this.mappings.putAll(m);
            return this;
        }

        public RecordingSubstitutionMap build() {
            RecordingSubstitutionMap built = new RecordingSubstitutionMap(this.delegate, this.shouldRecordMappingForCodeGeneration);
            built.initializeWithMappings(this.mappings);
            return built;
        }
    }
}

