/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;

public class RemoveDefaultDeclarations
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private boolean canRemoveDefaultValue = false;

    public RemoveDefaultDeclarations(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    @Override
    public boolean enterCompositeValueNode(CssCompositeValueNode node) {
        this.removeDefault(node);
        return true;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        this.removeDefault(node);
        return true;
    }

    private void removeDefault(CssValueNode node) {
        if (this.canRemoveDefaultValue && node.getIsDefault()) {
            this.visitController.removeCurrentNode();
        }
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode node) {
        boolean removeDeclaration = true;
        this.canRemoveDefaultValue = !node.getPropertyName().getProperty().hasPositionalParameters();
        for (CssValueNode value : node.getPropertyValue().childIterable()) {
            if (value instanceof CssPriorityNode) {
                removeDeclaration = false;
                this.canRemoveDefaultValue = false;
                break;
            }
            if (value.getIsDefault()) continue;
            removeDeclaration = false;
        }
        if (removeDeclaration) {
            this.visitController.removeCurrentNode();
        }
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode node) {
        this.canRemoveDefaultValue = false;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

