/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNodesListNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.UniformVisitor;

public class SExprPrintingVisitor
extends DefaultTreeVisitor
implements UniformVisitor {
    private final CodeBuffer buffer;
    private final boolean includeHashCodes;
    private final boolean withLocationAnnotation;

    public SExprPrintingVisitor(CodeBuffer buffer, boolean includeHashCodes, boolean withLocationAnnotation) {
        this.buffer = buffer;
        this.includeHashCodes = includeHashCodes;
        this.withLocationAnnotation = withLocationAnnotation;
    }

    @Override
    public void enter(CssNode node) {
        if (this.includeHashCodes) {
            this.buffer.append(String.format("(%s@%d ", node.getClass().getName(), node.hashCode()));
        } else {
            this.buffer.append(String.format("(%s ", node.getClass().getName()));
        }
        if (this.withLocationAnnotation) {
            SourceCodeLocation loc = node.getSourceCodeLocation();
            if (loc == null) {
                loc = SourceCodeLocation.getUnknownLocation();
            }
            this.buffer.append(String.format(":scl-unknown %s ", loc.isUnknown()));
        }
    }

    @Override
    public void leave(CssNode node) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(')');
    }

    @Override
    public boolean enterMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        super.enterMediaTypeListDelimiter(node);
        this.buffer.append("(MediaTypeListDelimiter");
        return true;
    }

    @Override
    public void leaveMediaTypeListDelimiter(CssNodesListNode<? extends CssNode> node) {
        this.buffer.append(')');
        super.leaveMediaTypeListDelimiter(node);
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        super.enterCompositeValueNodeOperator(parent);
        this.buffer.append("(CompositeValueNodeOperator ");
        this.buffer.append(parent.getOperator().name());
        return true;
    }

    @Override
    public void leaveCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.buffer.append(')');
        super.leaveCompositeValueNodeOperator(parent);
    }

    @Override
    public boolean enterValueNode(CssValueNode n) {
        super.enterValueNode(n);
        this.buffer.append(n + " ");
        return true;
    }

    @Override
    public void leaveValueNode(CssValueNode n) {
        super.leaveValueNode(n);
    }
}

