/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.StrictCssBase;
import java.util.Set;

public class StrictCss3
extends StrictCssBase {
    private static final ImmutableSet<CssCombinatorNode.Combinator> ALLOWED_COMBINATORS = ImmutableSet.of((Object)((Object)CssCombinatorNode.Combinator.DESCENDANT), (Object)((Object)CssCombinatorNode.Combinator.CHILD), (Object)((Object)CssCombinatorNode.Combinator.ADJACENT_SIBLING), (Object)((Object)CssCombinatorNode.Combinator.GENERAL_SIBLING));
    private static final ImmutableSet<String> PSEUDO_CLASSES = ImmutableSet.of((Object)"root", (Object)"first-child", (Object)"last-child", (Object)"first-of-type", (Object)"last-of-type", (Object)"only-child", (Object[])new String[]{"only-of-type", "empty", "link", "visited", "active", "hover", "focus", "target", "enabled", "disabled", "checked", "indeterminate", "default", "valid", "invalid", "in-range", "out-of-range", "required", "optional", "read-only", "read-write"});
    private static final ImmutableSet<String> PSEUDO_CLASSES_NTH = ImmutableSet.of((Object)"nth-child", (Object)"nth-last-child", (Object)"nth-of-type", (Object)"nth-last-of-type");
    private static final ImmutableSet<String> PSEUDO_ELEMENTS = ImmutableSet.of((Object)"first-line", (Object)"first-letter", (Object)"before", (Object)"after", (Object)"value", (Object)"choices", (Object[])new String[]{"repeat-item", "repeat-index"});
    private static final Set<String> UNITS = Sets.newHashSet((Object[])new String[]{"", "em", "ex", "%", "ch", "rem", "vw", "vh", "vm", "in", "cm", "mm", "pt", "pc", "px", "deg", "grad", "rad", "turn", "s", "ms", "hz", "khz"});
    @VisibleForTesting
    static final String UNSUPPORTED_COMBINATOR_ERROR_MESSAGE = "An unsupported combinator is used.";
    @VisibleForTesting
    static final String UNSUPPORTED_PESUDO_CLASS_ERROR_MESSAGE = "An unsupported pseudo-class is used.";
    @VisibleForTesting
    static final String UNSUPPORTED_PESUDO_CLASS_NTH_ERROR_MESSAGE = "An unsupported pseudo-class for the nth-pattern is used.";
    @VisibleForTesting
    static final String UNSUPPORTED_PESUDO_ELEMENT_ERROR_MESSAGE = "An unsupported pseudo-element is used.";
    @VisibleForTesting
    static final String MISSING_FUNCTION_PESUDO_CLASS_NTH_ERROR_MESSAGE = "A pseudo-class for the nth-pattern is used without an argument.";

    public StrictCss3(VisitController visitController, ErrorManager errorManager) {
        super(visitController, errorManager);
    }

    @Override
    Set<String> getValidCssUnits() {
        return UNITS;
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (!ALLOWED_COMBINATORS.contains((Object)combinator.getCombinatorType())) {
            this.errorManager.report(new GssError(UNSUPPORTED_COMBINATOR_ERROR_MESSAGE, combinator.getSourceCodeLocation()));
            return false;
        }
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        switch (node.getFunctionType()) {
            case NONE: {
                return this.checkNonFunctionPseudoClass(node);
            }
            case LANG: 
            case NOT: {
                break;
            }
            case NTH: {
                return this.checkNthFunctionPseudoClass(node);
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + node.getFunctionType());
            }
        }
        return true;
    }

    private boolean checkNonFunctionPseudoClass(CssRefinerNode refiner) {
        if (PSEUDO_CLASSES_NTH.contains((Object)refiner.getRefinerName())) {
            this.errorManager.report(new GssError(MISSING_FUNCTION_PESUDO_CLASS_NTH_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        if (!PSEUDO_CLASSES.contains((Object)refiner.getRefinerName())) {
            this.reportUnsupported(refiner, UNSUPPORTED_PESUDO_CLASS_ERROR_MESSAGE, (Set<String>)PSEUDO_CLASSES);
            return false;
        }
        return true;
    }

    private boolean checkNthFunctionPseudoClass(CssRefinerNode refiner) {
        String name = refiner.getRefinerName();
        if (!name.endsWith("(") || !PSEUDO_CLASSES_NTH.contains((Object)name.substring(0, name.length() - 1))) {
            this.reportUnsupported(refiner, UNSUPPORTED_PESUDO_CLASS_NTH_ERROR_MESSAGE, (Set<String>)PSEUDO_CLASSES_NTH);
            return false;
        }
        return true;
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        if (!PSEUDO_ELEMENTS.contains((Object)node.getRefinerName())) {
            this.reportUnsupported(node, UNSUPPORTED_PESUDO_ELEMENT_ERROR_MESSAGE, (Set<String>)PSEUDO_ELEMENTS);
            return false;
        }
        return true;
    }
}

