/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.CompactPrinter;
import com.google.common.css.compiler.passes.TemplateCompactPrintingVisitor;

public class TemplateCompactPrinter<T>
extends CompactPrinter {
    public static final char REFERENCE_START = '\u0123';
    public static final char REFERENCE_END = '\u0122';
    public static final char REFERENCE_START_OLD = '$';
    public static final char REFERENCE_END_OLD = '^';
    public static final char DECLARATION_START = '\u0105';
    public static final char DECLARATION_END = '\u0104';
    public static final char RULE_START = '\u0118';
    public static final char RULE_END = '\u0119';
    protected final T chunk;

    public TemplateCompactPrinter(CssTree tree, T chunk) {
        super(tree, (CodeBuffer)new CodeBufferForTemplate(), null);
        this.chunk = chunk;
    }

    @Override
    protected CssTreeVisitor createVisitor(VisitController visitController, CodeBuffer buffer) {
        return new TemplateCompactPrintingVisitor<T>(visitController, this.chunk, buffer);
    }

    private static final class CodeBufferForTemplate
    extends CodeBuffer {
        private CodeBufferForTemplate() {
        }

        @Override
        public void deleteLastCharIfCharIs(char ch) {
            if (ch == ';' && this.getLastChar() == '\u0104') {
                this.deleteLastChars(2);
                this.append('\u0104');
            } else {
                super.deleteLastCharIfCharIs(ch);
            }
        }
    }
}

