/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssCharSetNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssIdSelectorNode;
import com.google.common.css.compiler.ast.CssImportRuleNode;
import com.google.common.css.compiler.ast.CssKeyframeRulesetNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssPageRuleNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.CompactPrintingVisitor;
import javax.annotation.Nullable;

public class TemplateCompactPrintingVisitor<T>
extends CompactPrintingVisitor {
    private final T chunk;
    private boolean printSelector;

    public TemplateCompactPrintingVisitor(VisitController visitController, T chunk, @Nullable CodeBuffer buffer) {
        super(visitController, buffer);
        this.chunk = chunk;
    }

    @Override
    protected void appendValueNode(CssValueNode node) {
        if (node instanceof CssConstantReferenceNode) {
            this.buffer.append('\u0123');
            super.appendValueNode(node);
            this.buffer.append('\u0122');
        } else {
            super.appendValueNode(node);
        }
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        this.buffer.append('\u0105');
        return super.enterDeclaration(declaration);
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode declaration) {
        super.leaveDeclaration(declaration);
        this.buffer.append('\u0104');
    }

    @Override
    public boolean enterRuleset(CssRulesetNode ruleset) {
        boolean printRuleset = false;
        for (CssSelectorNode selector : ruleset.getSelectors().childIterable()) {
            if (!this.chunk.equals(selector.getChunk())) continue;
            printRuleset = true;
            break;
        }
        if (printRuleset) {
            this.buffer.append('\u0118');
        }
        return printRuleset;
    }

    @Override
    public void leaveRuleset(CssRulesetNode ruleset) {
        this.buffer.append('\u0119');
        super.leaveRuleset(ruleset);
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode media) {
        boolean printMediaRule;
        this.buffer.append('\u0118');
        this.printSelector = this.chunk.equals(media.getChunk());
        boolean bl = printMediaRule = this.printSelector && super.enterMediaRule(media);
        if (!printMediaRule) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printMediaRule;
    }

    @Override
    public void leaveMediaRule(CssMediaRuleNode media) {
        if (this.printSelector) {
            super.leaveMediaRule(media);
        }
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        this.printSelector = this.chunk.equals(selector.getChunk());
        if (this.printSelector) {
            return super.enterSelector(selector);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        if (this.printSelector) {
            super.leaveSelector(selector);
        }
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode cssFontFaceNode) {
        boolean printFontFace;
        this.buffer.append('\u0118');
        this.printSelector = this.chunk.equals(cssFontFaceNode.getChunk());
        boolean bl = printFontFace = this.printSelector && super.enterFontFace(cssFontFaceNode);
        if (!printFontFace) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printFontFace;
    }

    @Override
    public void leaveFontFace(CssFontFaceNode cssFontFaceNode) {
        if (this.printSelector) {
            super.leaveFontFace(cssFontFaceNode);
        }
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterCharSet(CssCharSetNode cssCharSetNode) {
        this.buffer.append('\u0118');
        boolean printFontFace = super.enterCharSet(cssCharSetNode);
        if (!printFontFace) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printFontFace;
    }

    @Override
    public void leaveCharSet(CssCharSetNode cssCharSetNode) {
        if (this.printSelector) {
            super.leaveCharSet(cssCharSetNode);
        }
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterKeyframeRuleset(CssKeyframeRulesetNode ruleset) {
        this.buffer.append('\u0118');
        boolean printKeyframeRuleset = super.enterKeyframeRuleset(ruleset);
        if (!printKeyframeRuleset) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printKeyframeRuleset;
    }

    @Override
    public void leaveKeyframeRuleset(CssKeyframeRulesetNode ruleset) {
        super.leaveKeyframeRuleset(ruleset);
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode keyframes) {
        this.printSelector = this.chunk.equals(keyframes.getChunk());
        if (!this.printSelector) {
            return false;
        }
        return super.enterKeyframesRule(keyframes);
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode keyframes) {
        if (this.printSelector) {
            super.leaveKeyframesRule(keyframes);
        }
    }

    @Override
    public boolean enterPageRule(CssPageRuleNode node) {
        this.buffer.append('\u0118');
        boolean printPageRule = super.enterPageRule(node);
        if (!printPageRule) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printPageRule;
    }

    @Override
    public void leavePageRule(CssPageRuleNode node) {
        super.leavePageRule(node);
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        if (this.printSelector) {
            return super.enterClassSelector(node);
        }
        return true;
    }

    @Override
    public void leaveClassSelector(CssClassSelectorNode node) {
        if (this.printSelector) {
            super.leaveClassSelector(node);
        }
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        this.buffer.append('\u0118');
        boolean printUnknownAtRule = super.enterUnknownAtRule(node);
        if (!printUnknownAtRule) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printUnknownAtRule;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        super.leaveUnknownAtRule(node);
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterImportRule(CssImportRuleNode node) {
        this.buffer.append('\u0118');
        boolean printImportRule = super.enterImportRule(node);
        if (!printImportRule) {
            this.buffer.deleteLastCharIfCharIs('\u0118');
        }
        return printImportRule;
    }

    @Override
    public void leaveImportRule(CssImportRuleNode node) {
        super.leaveImportRule(node);
        this.buffer.append('\u0119');
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        if (this.printSelector) {
            return super.enterIdSelector(node);
        }
        return true;
    }

    @Override
    public void leaveIdSelector(CssIdSelectorNode node) {
        if (this.printSelector) {
            super.leaveIdSelector(node);
        }
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        if (this.printSelector) {
            return super.enterPseudoClass(node);
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (this.printSelector) {
            super.leavePseudoClass(node);
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        if (this.printSelector) {
            return super.enterPseudoElement(node);
        }
        return true;
    }

    @Override
    public void leavePseudoElement(CssPseudoElementNode node) {
        if (this.printSelector) {
            super.leavePseudoElement(node);
        }
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        if (this.printSelector) {
            return super.enterAttributeSelector(node);
        }
        return true;
    }

    @Override
    public void leaveAttributeSelector(CssAttributeSelectorNode node) {
        if (this.printSelector) {
            super.leaveAttributeSelector(node);
        }
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (this.printSelector) {
            return super.enterCombinator(combinator);
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        if (this.printSelector) {
            super.leaveCombinator(combinator);
        }
    }
}

