/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssForLoopRuleNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssLoopVariableNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.LoopVariableReplacementPass;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class UnrollLoops
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String UNKNOWN_CONSTANT = "Unknown constant used in for loop.";
    @VisibleForTesting
    static final String UNKNOWN_VARIABLE = "For loop variable is used before it was evaluated.";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;

    public UnrollLoops(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterForLoop(CssForLoopRuleNode node) {
        GatherLoopDefinitions definitionsGatherer = new GatherLoopDefinitions();
        node.getVisitController().startVisit(definitionsGatherer);
        Set<String> definitions = definitionsGatherer.getLoopDefinitions();
        Integer from = this.getNumberValue(node.getFrom());
        Integer to = this.getNumberValue(node.getTo());
        Integer step = this.getNumberValue(node.getStep());
        if (from == null || to == null || step == null) {
            this.visitController.removeCurrentNode();
            return false;
        }
        ArrayList blocks = Lists.newArrayListWithCapacity((int)((to - from + step) / step));
        for (int i = from.intValue(); i <= to; i += step.intValue()) {
            blocks.addAll(this.makeBlock(node, i, definitions, node.getLoopId()).getChildren());
        }
        this.visitController.replaceCurrentBlockChildWith(blocks, true);
        return true;
    }

    private CssBlockNode makeBlock(CssForLoopRuleNode node, int value, Set<String> definitions, int loopId) {
        CssBlockNode newBlock = new CssBlockNode(false, node.getBlock().deepCopy().getChildren());
        newBlock.setSourceCodeLocation(node.getSourceCodeLocation());
        CssTree tree = new CssTree(null, new CssRootNode(newBlock));
        new LoopVariableReplacementPass(node.getVariableName(), value, definitions, tree.getMutatingVisitController(), loopId).runPass();
        return newBlock;
    }

    @Nullable
    private Integer getNumberValue(CssValueNode node) {
        if (node instanceof CssNumericNode) {
            return Integer.parseInt(((CssNumericNode)node).getNumericPart());
        }
        if (node instanceof CssLoopVariableNode) {
            this.reportError(UNKNOWN_VARIABLE, node);
        } else if (node instanceof CssLiteralNode) {
            this.reportError(UNKNOWN_CONSTANT, node);
        } else {
            throw new RuntimeException("Unsupported value type for loop variable: " + node.getClass());
        }
        return null;
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private static class GatherLoopDefinitions
    extends DefaultTreeVisitor {
        private final Set<String> loopDefinitions = new HashSet<String>();

        private GatherLoopDefinitions() {
        }

        public Set<String> getLoopDefinitions() {
            return this.loopDefinitions;
        }

        @Override
        public boolean enterDefinition(CssDefinitionNode node) {
            this.loopDefinitions.add(node.getName().getValue());
            return true;
        }
    }
}

