/*
 * Decompiled with CFR 0.152.
 */
package org.padler.natorder;

import java.util.Comparator;

public class NaturalOrderComparator
implements Comparator<String> {
    private boolean caseSensitive;

    public NaturalOrderComparator() {
        this.caseSensitive = false;
    }

    public NaturalOrderComparator(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    private int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = this.charAt(a, ia);
            char cb = this.charAt(b, ib);
            boolean isADigit = this.isDigit(ca);
            boolean isBDigit = this.isDigit(cb);
            if (!isADigit && !isBDigit) {
                return bias;
            }
            if (!isADigit) {
                return -1;
            }
            if (!isBDigit) {
                return 1;
            }
            if (bias == 0) {
                if (ca < cb) {
                    bias = -1;
                } else if (ca > cb) {
                    bias = 1;
                }
            }
            ++ia;
            ++ib;
        }
    }

    @Override
    public int compare(String o1, String o2) {
        int ia = 0;
        int ib = 0;
        while (true) {
            int bias;
            int nzb = 0;
            int nza = 0;
            char ca = this.charAt(o1, ia);
            char cb = this.charAt(o2, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = this.charAt(o1, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = this.charAt(o2, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (bias = this.compareRight(o1.substring(ia), o2.substring(ib))) != 0) {
                return bias;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return this.compareEqual(o1, o2, nza, nzb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    private int compareEqual(String a, String b, int nza, int nzb) {
        if (nza - nzb != 0) {
            return nza - nzb;
        }
        if (a.length() == b.length()) {
            return a.compareTo(b);
        }
        return a.length() - b.length();
    }

    private char charAt(String s, int i) {
        if (this.caseSensitive) {
            return i >= s.length() ? (char)'\u0000' : s.charAt(i);
        }
        return i >= s.length() ? (char)'\u0000' : Character.toUpperCase(s.charAt(i));
    }
}

