/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigurationImportFilter;
import org.springframework.boot.autoconfigure.AutoConfigurationMetadata;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DBAutoConfigurationImportFilter
implements AutoConfigurationImportFilter,
EnvironmentAware {
    private static final Set<String> SHOULD_SKIP = new HashSet<String>(Collections.singletonList("org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration"));
    private boolean enabled;

    public void setEnvironment(Environment environment) {
        this.enabled = (Boolean)environment.getProperty("thyDbAdmin.saveMode.enabled", Boolean.class, (Object)true);
    }

    public boolean[] match(String[] classNames, AutoConfigurationMetadata metadata) {
        boolean[] matches = new boolean[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            boolean skip = SHOULD_SKIP.contains(classNames[i]);
            matches[i] = !skip || !this.enabled;
        }
        return matches;
    }
}

