/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.service;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataAccessService {
    @PersistenceContext
    protected EntityManager entityManager;

    public Page<Map<String, Object>> executeQuery(String sql, int page, int pageSize) {
        BigInteger countResult = this.countQuery(sql);
        Query query = this.entityManager.createNativeQuery(sql);
        org.hibernate.query.Query hibernateQuery = (org.hibernate.query.Query)query;
        hibernateQuery.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        hibernateQuery.setFirstResult(page * pageSize);
        hibernateQuery.setMaxResults(pageSize);
        return new PageImpl(hibernateQuery.getResultList(), (Pageable)PageRequest.of((int)page, (int)pageSize), countResult.longValue());
    }

    private BigInteger countQuery(String sql) {
        String count = "SELECT COUNT(*) AS total FROM ({})".replace("{}", sql);
        Query query = this.entityManager.createNativeQuery(count);
        List resultList = query.getResultList();
        return (BigInteger)resultList.get(0);
    }

    @Transactional
    public int executeUpdate(String sql) {
        return this.entityManager.createNativeQuery(sql).executeUpdate();
    }
}

