/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.service;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.hibernate.JDBCException;
import org.hibernate.exception.SQLGrammarException;
import org.padler.thydbadmin.service.DataAccessService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DbAdminService {
    @PersistenceContext
    protected EntityManager entityManager;
    private final DataAccessService dataAccessService;
    private final DataSource dataSource;

    public DbAdminService(DataAccessService dataAccessService, DataSource dataSource) {
        this.dataAccessService = dataAccessService;
        this.dataSource = dataSource;
    }

    public Page<Map<String, Object>> executeQuery(String sql) {
        return this.executeQuery(sql, 0, 10);
    }

    public Page<Map<String, Object>> executeQuery(String sql, int page, int pageSize) {
        try {
            return this.dataAccessService.executeQuery(sql, page, pageSize);
        }
        catch (Exception e) {
            this.dataAccessService.executeUpdate(sql);
            return null;
        }
    }

    public List<String> getTables() {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(null, null, null, new String[]{"TABLE"});
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                result.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("", e);
        }
        return result;
    }

    public List<String> getColumns(String tableName) {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet columns = metaData.getColumns(null, null, tableName, "%");
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                Integer position = columns.getInt("ORDINAL_POSITION");
                result.put(position, columnName);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("", e);
        }
        return new ArrayList<String>(result.values());
    }

    public DatabaseMetaData getInfo() {
        DatabaseMetaData databaseMetaData;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                databaseMetaData = connection.getMetaData();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JDBCException("", e);
                }
            }
            connection.close();
        }
        return databaseMetaData;
    }

    public Page<Object[]> getData(String tableName, int page, int pageSize) {
        List<String> tables = this.getTables();
        Optional<String> first = tables.stream().filter(s -> s.equalsIgnoreCase(tableName)).findFirst();
        String tableNameFromDB = first.orElseThrow(() -> new SQLGrammarException("could not prepare statement", (SQLException)new SQLSyntaxErrorException("No such table " + tableName)));
        Query count = this.entityManager.createNativeQuery("SELECT COUNT(*) FROM " + tableNameFromDB);
        BigInteger countResult = (BigInteger)count.getSingleResult();
        Query select = this.entityManager.createNativeQuery("SELECT * FROM " + tableNameFromDB);
        select.setMaxResults(pageSize);
        select.setFirstResult(pageSize * page);
        return new PageImpl(select.getResultList(), (Pageable)PageRequest.of((int)page, (int)pageSize), countResult.longValue());
    }
}

