/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.controller;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import javax.servlet.http.HttpServletRequest;
import org.padler.thydbadmin.service.DbAdminService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@ConditionalOnProperty(value={"thyDbAdmin.controller"})
@Controller
@RequestMapping(value={"/thyDbAdmin"})
public class ThyDbAdminController {
    public static final String COLUMNS = "columns";
    public static final String TABLE = "table";
    public static final String PAGE = "page";
    public static final String PAGES = "pages";
    public static final String PAGE_SIZE = "pageSize";
    public static final String ROWS = "rows";
    public static final String QUERY = "query";
    public static final String TOTAL = "total";
    private final DbAdminService dbAdminService;

    public ThyDbAdminController(DbAdminService dbAdminService) {
        this.dbAdminService = dbAdminService;
    }

    @GetMapping(value={""})
    public String getTables(Model model) {
        List<String> tables = this.dbAdminService.getTables();
        model.addAttribute("tables", tables);
        return "tables";
    }

    @GetMapping(value={"/table/{tableName}"})
    public String getTable(@PathVariable String tableName, @RequestParam(required=false, defaultValue="0") Integer page, @RequestParam(required=false, defaultValue="10") Integer pageSize, Model model) {
        Page<Map<String, Object>> result = this.dbAdminService.getData(tableName, page, pageSize);
        model.addAttribute("tableName", (Object)tableName);
        if (result.isEmpty()) {
            List<String> columns = this.dbAdminService.getColumns(tableName);
            model.addAttribute(COLUMNS, columns);
        } else {
            model.addAttribute(COLUMNS, this.getColumnNames(result));
        }
        model.addAttribute(ROWS, (Object)result.getContent());
        model.addAttribute(PAGE, (Object)page);
        model.addAttribute(PAGES, (Object)result.getTotalPages());
        model.addAttribute(PAGE_SIZE, (Object)pageSize);
        model.addAttribute(TOTAL, (Object)result.getTotalElements());
        return TABLE;
    }

    @GetMapping(value={"/info"})
    public String getInfo(Model model) {
        DatabaseMetaData info = this.dbAdminService.getInfo();
        model.addAttribute("info", (Object)info);
        return "info";
    }

    @GetMapping(value={"/queryResult"})
    public String getQueryResult() {
        return "queryResult";
    }

    @PostMapping(value={"/executeQuery"})
    public String postExecuteQuery(String query, HttpServletRequest request, RedirectAttributes redirectAttributes, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false, defaultValue="10") int pageSize) {
        String referer = request.getHeader("Referer");
        Page<Map<String, Object>> result = null;
        try {
            result = this.dbAdminService.executeQuery(query, page, pageSize);
        }
        catch (PersistenceException e) {
            redirectAttributes.addFlashAttribute("error", (Object)e.getCause().getCause().getMessage());
        }
        if (result == null) {
            return "redirect:" + referer;
        }
        redirectAttributes.addFlashAttribute(COLUMNS, this.getColumnNames(result));
        redirectAttributes.addFlashAttribute(ROWS, (Object)result.getContent());
        redirectAttributes.addFlashAttribute(PAGE, (Object)page);
        redirectAttributes.addFlashAttribute(PAGES, (Object)result.getTotalPages());
        redirectAttributes.addFlashAttribute(PAGE_SIZE, (Object)pageSize);
        redirectAttributes.addFlashAttribute(QUERY, (Object)query);
        redirectAttributes.addFlashAttribute(TOTAL, (Object)result.getTotalElements());
        return "redirect:queryResult";
    }

    private ArrayList<String> getColumnNames(Page<Map<String, Object>> result) {
        List list = result.getContent().stream().map(Map::values).collect(Collectors.toList());
        ArrayList columns = null;
        if (!list.isEmpty()) {
            columns = new ArrayList(((Map)result.getContent().get(0)).keySet());
        }
        return columns;
    }
}

