/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.service;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.hibernate.JDBCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataAccessService {
    private static final Logger logger = LoggerFactory.getLogger(DataAccessService.class);
    public static final String QUERY_SELECT_COUNT = "SELECT COUNT(*) AS total FROM ({}) AS query";
    public static final String DATABASE_PRODUCT_NAME_PG = "PostgreSQL";
    public static final String DATABASE_PRODUCT_NAME_MY = "MySQL";
    public static final String DATABASE_PRODUCT_NAME_H2 = "H2";
    public static final String DATABASE_PRODUCT_NAME_DB2 = "DB2";
    public static final String QUERY_SELECT_ALL = "SELECT * FROM ";
    public static final String QUERY_LIMIT = " LIMIT ";
    @PersistenceContext
    protected EntityManager entityManager;
    private final DataSource dataSource;

    public DataAccessService(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DatabaseMetaData getInfo() {
        DatabaseMetaData databaseMetaData;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                databaseMetaData = connection.getMetaData();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new JDBCException("", e);
                }
            }
            connection.close();
        }
        return databaseMetaData;
    }

    public Page<Map<String, Object>> executeQuery(String sql, int page, int pageSize) {
        BigInteger countResult = this.countQuery(sql);
        List<Map<String, Object>> resultList = this.jdbcQuery(sql, page, pageSize);
        if (resultList.size() > pageSize) {
            return new PageImpl(resultList, (Pageable)PageRequest.of((int)0, (int)resultList.size()), countResult.longValue());
        }
        return new PageImpl(resultList, (Pageable)PageRequest.of((int)page, (int)pageSize), countResult.longValue());
    }

    private String createPaging(String sql, int page, int pageSize) {
        DatabaseMetaData info = this.getInfo();
        String dbVendor = "";
        int offset = page * pageSize;
        try {
            dbVendor = info.getDatabaseProductName();
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        switch (dbVendor) {
            case "PostgreSQL": {
                sql = "SELECT * FROM  (" + sql + ") AS query" + QUERY_LIMIT + pageSize + " OFFSET " + offset;
                break;
            }
            case "DB2": 
            case "H2": 
            case "MySQL": {
                sql = "SELECT * FROM  (" + sql + ") AS query" + QUERY_LIMIT + pageSize + ", " + offset;
                break;
            }
        }
        return sql;
    }

    private List<Map<String, Object>> jdbcQuery(String sql, int page, int pageSize) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try (Connection connection = this.dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(this.createPaging(sql, page, pageSize));){
            ResultSetMetaData rsmd = resultSet.getMetaData();
            while (resultSet.next()) {
                HashMap<String, String> result = new HashMap<String, String>();
                for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String columnData = resultSet.getString(i);
                    result.put(columnName, columnData);
                }
                resultList.add(result);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
        return resultList;
    }

    private BigInteger countQuery(String sql) {
        String count = QUERY_SELECT_COUNT.replace("{}", sql);
        Query query = this.entityManager.createNativeQuery(count);
        List resultList = query.getResultList();
        return (BigInteger)resultList.get(0);
    }

    @Transactional
    public int executeUpdate(String sql) {
        return this.entityManager.createNativeQuery(sql).executeUpdate();
    }
}

