/*
 * Decompiled with CFR 0.152.
 */
package org.padler.thydbadmin.service;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.hibernate.JDBCException;
import org.hibernate.MappingException;
import org.hibernate.exception.SQLGrammarException;
import org.padler.thydbadmin.service.DataAccessService;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class DbAdminService {
    private final DataAccessService dataAccessService;
    private final DataSource dataSource;

    public DbAdminService(DataAccessService dataAccessService, DataSource dataSource) {
        this.dataAccessService = dataAccessService;
        this.dataSource = dataSource;
    }

    public Page<Map<String, Object>> executeQuery(String sql) {
        return this.executeQuery(sql, 0, 10);
    }

    public Page<Map<String, Object>> executeQuery(String sql, int page, int pageSize) {
        if ((sql = sql.trim()).toUpperCase().startsWith("SELECT")) {
            try {
                return this.dataAccessService.executeQuery(sql, page, pageSize);
            }
            catch (Exception e) {
                if (e.getCause() instanceof MappingException) {
                    return Page.empty();
                }
                throw e;
            }
        }
        this.dataAccessService.executeUpdate(sql);
        return null;
    }

    public List<String> getTables() {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(null, null, null, new String[]{"TABLE"});
            while (tables.next()) {
                String tableName = tables.getString("TABLE_NAME");
                result.add(tableName);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("", e);
        }
        return result;
    }

    public List<String> getColumns(String tableName) {
        TreeMap<Integer, String> result = new TreeMap<Integer, String>();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet columns = metaData.getColumns(null, null, tableName, "%");
            while (columns.next()) {
                String columnName = columns.getString("COLUMN_NAME");
                Integer position = columns.getInt("ORDINAL_POSITION");
                result.put(position, columnName);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("", e);
        }
        return new ArrayList<String>(result.values());
    }

    public DatabaseMetaData getInfo() {
        return this.dataAccessService.getInfo();
    }

    public Page<Map<String, Object>> getData(String tableName, int page, int pageSize) {
        List<String> tables = this.getTables();
        Optional<String> first = tables.stream().filter(s -> s.equalsIgnoreCase(tableName)).findFirst();
        String tableNameFromDB = first.orElseThrow(() -> new SQLGrammarException("could not prepare statement", (SQLException)new SQLSyntaxErrorException("No such table " + tableName)));
        return this.dataAccessService.executeQuery("SELECT * FROM " + tableNameFromDB, page, pageSize);
    }
}

